/*
 * Created on 29-jul-2008
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.Version;

/**
 * The NonSiraPriseErrorMessageType is the type of message returned by a SIRA_PRISE server to a client in the case when a command issued by that client has resulted in an exception being thrown by the Java environment, such as e.g. Java security exceptions, stack overflow errors, ...
 * 
 * @author Erwin Smout
 */
public abstract class NonSiraPriseErrorMessageType extends ErrorMessageType {

	/**
	 * Comment for <code>MESSAGETYPEID</code>
	 */
	public static final int MESSAGETYPEID = 0x33333333;

	/**
	 * Creates the instance for some version of this message type
	 * 
	 * @param messageVersion
	 *            the Version indicator of the message type
	 * @param introducedInSiraPriseVersion
	 *            Gets the SIRA_PRISE specification version in which this message type (version !) was introduced.
	 */
	NonSiraPriseErrorMessageType (Version messageVersion, Version introducedInSiraPriseVersion) {
		super(MESSAGETYPEID, messageVersion, introducedInSiraPriseVersion);
	}

	/**
	 * Factory method for getting a message of this version of the type holding the given java exception data
	 * 
	 * @param exceptionClassName
	 *            The class name of the thrown non-sira-prise exception that caused this message to (have to be) sent
	 * @param exceptionMessage
	 *            The exception message contained in the thrown exception object
	 * @return A NonSiraPriseErrorMessage of the appropriate version reflecting the given exception class name and exception message
	 */
	public final NonSiraPriseErrorMessage message (String exceptionClassName, String exceptionMessage) {
		return message(exceptionClassName, exceptionMessage, false);
	}

	/**
	 * Factory method for getting a message of this version of the type holding the given java exception data
	 * 
	 * @param exceptionClassName
	 *            The class name of the thrown non-sira-prise exception that caused this message to (have to be) sent
	 * @param exceptionMessage
	 *            The exception message contained in the thrown exception object
	 * @param fatal
	 *            Flag indicating whether the error was 'fatal', i.e. whether the server has aborted its side of the transaction as a consequence of the error
	 * @return A NonSiraPriseErrorMessage of the appropriate version reflecting the given exception class name and exception message
	 */
	public abstract NonSiraPriseErrorMessage message (String exceptionClassName, String exceptionMessage, boolean fatal);

}