/*
 * Created on 29-jul-2008
 */
package be.SIRAPRISE.messages;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.util.MyDataInputStream;
import be.SIRAPRISE.util.MyDataOutputStream;

/**
 * NonSiraPriseErrorMessageTypeV1_0 is V1_0 of the NonSiraPriseErrorMessageType.
 * <P>
 * This message has the following fields :
 * </P>
 * <table border="1" cellpadding="2" cellspacing="1" width="100%">
 * <tbody>
 * <tr>
 * <th width="24%">Zone</th>
 * <th width="12%">Format</th>
 * <th width="9%">Length</th>
 * <th width="55%">Description</th>
 * </tr>
 * <tr>
 * <td>ERRORTYPE</td>
 * <td>STRING</td>
 * <td>&nbsp;</td>
 * <td>The name of the java Exception class that was encountered.</td>
 * </tr>
 * <tr>
 * <td>ERRORMESSAGE</td>
 * <td>STRING</td>
 * <td>&nbsp;</td>
 * <td>The result of the Java getMessage() method invoked on the Java exception object.</td>
 * </tr>
 * </tbody>
 * </table>
 * 
 * @author Erwin Smout
 * @since SIRA_PRISE 1.1
 */
public final class NonSiraPriseErrorMessageTypeV1_0 extends NonSiraPriseErrorMessageType {

	/**
	 * the instance
	 */
	private static NonSiraPriseErrorMessageType instance = new NonSiraPriseErrorMessageTypeV1_0();

	/**
	 * Gets the instance
	 * 
	 * @return the instance
	 */
	static NonSiraPriseErrorMessageType getInstance ( ) {
		return instance;
	}

	/**
	 * 
	 */
	private NonSiraPriseErrorMessageTypeV1_0 ( ) {
		super(Version.ONE_ZERO, Version.ONE_ZERO);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificFromStream(java.io.DataInputStream)
	 */
	ServerMessage typeSpecificFromStream (DataInputStream in) throws IOException {
		String throwableClassName = MyDataInputStream.getSmallUTFString(in);
		String throwableMessage = MyDataInputStream.getSmallUTFString(in);
		return new NonSiraPriseErrorMessageV1_0(throwableClassName, throwableMessage);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificToStream(be.erwinsmout.SIRA_PRISE.client.ServerMessage, java.io.DataOutputStream)
	 */
	void typeSpecificToStream (ServerMessage message, DataOutputStream outputStream) throws IOException {
		if (!(message instanceof NonSiraPriseErrorMessageV1_0)) {
			throw new IllegalArgumentException();
		}

		NonSiraPriseErrorMessageV1_0 nonSiraPriseErrorMessageV1_0 = (NonSiraPriseErrorMessageV1_0) message;

		MyDataOutputStream.writeSmallUTF(nonSiraPriseErrorMessageV1_0.getClassName(), outputStream);
		MyDataOutputStream.writeSmallUTF(nonSiraPriseErrorMessageV1_0.getOriginalExceptionMessage(), outputStream);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.NonSiraPriseErrorMessageType#message(java.lang.String, java.lang.String)
	 */
	public NonSiraPriseErrorMessage message (String exceptionClassName, String exceptionMessage, boolean fatal) {
		return new NonSiraPriseErrorMessageV1_0(exceptionClassName, exceptionMessage);
	}
}