/*
 * Created on 24-jul-2008
 */
package be.SIRAPRISE.messages;

import java.security.Signature;
import java.util.Set;

import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.security.ProprietaryOrJCECipher;

/**
 * @author Erwin Smout
 */
public abstract class ServerHelloMessage extends ServerOutputMessage {

	/**
	 * The set of alternative signing protocols that the server engine supports (e.g. for user identity signing)
	 */
	private Set<String> alternativeSigningProtocols;

	/**
	 * The name of the encryption/decryption protocol to be used on the connection
	 */
	private ProprietaryOrJCECipher cryptoProtocol;

	/**
	 * The idle time for the connection as decided upon by the server
	 */
	private long idleTime;

	/**
	 * The name of the signing protocol to be used on the connection
	 */
	private Signature signingProtocol;

	/**
	 * The SIRA_PRISE version to use when deciding what message versions to send/interpret
	 */
	private Version version;

	/**
	 * @param type
	 * @param signingProtocol
	 *            The name of the signing protocol to be used on the connection
	 * @param cryptoProtocol
	 *            The name of the encryption/decryption protocol to be used on the connection
	 * @param idleTime
	 *            The idle time for the connection as decided upon by the server
	 * @param version
	 *            The SIRA_PRISE version to use when deciding what message versions to send/interpret
	 * @param alternativeSigningProtocols
	 *            The set of alternative signing protocols that the server engine supports (e.g. for user identity signing)
	 */
	ServerHelloMessage (ServerHelloMessageType type, Signature signingProtocol, ProprietaryOrJCECipher cryptoProtocol, long idleTime, Version version, Set<String> alternativeSigningProtocols) {
		super(type);
		this.signingProtocol = signingProtocol;
		this.cryptoProtocol = cryptoProtocol;
		this.idleTime = idleTime;
		this.version = version;
		this.alternativeSigningProtocols = alternativeSigningProtocols;
	}

	/**
	 * Gets The idle time for the connection as decided upon by the server
	 * 
	 * @return The idle time for the connection as decided upon by the server
	 */
	long getIdleTime ( ) {
		return idleTime;
	}

	/**
	 * Gets The set of alternative signing protocols that the server engine supports (e.g. for user identity signing)
	 * 
	 * @return The set of alternative signing protocols that the server engine supports (e.g. for user identity signing)
	 */
	public Set<String> getAlternativeSigningProtocols ( ) {
		return alternativeSigningProtocols;
	}

	/**
	 * Gets The name of the encryption/decryption protocol to be used on the connection
	 * 
	 * @return The name of the encryption/decryption protocol to be used on the connection
	 */
	public ProprietaryOrJCECipher getCryptoProtocol ( ) {
		return cryptoProtocol;
	}

	/**
	 * Gets The name of the signing protocol to be used on the connection
	 * 
	 * @return The name of the signing protocol to be used on the connection
	 */
	public Signature getSigningProtocol ( ) {
		return signingProtocol;
	}

	/**
	 * Gets The SIRA_PRISE version to use when deciding what message versions to send/interpret
	 * 
	 * @return The SIRA_PRISE version to use when deciding what message versions to send/interpret
	 */
	public Version getVersion ( ) {
		return version;
	}
}
