/*
 * Created on 24-jul-2008
 */
package be.SIRAPRISE.messages;

import java.security.Signature;
import java.util.Set;

import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.security.ProprietaryOrJCECipher;

/**
 * ServerHelloMessageType is the class representing all known versions of the server hello message type.
 * 
 * @author Erwin Smout
 */
public abstract class ServerHelloMessageType extends ServerOutputMessageType {

	/**
	 * The numeric ID for messages of this type
	 */
	public static final int MESSAGETYPEID = 0x1BAFF1ED;

	/**
	 * Creates the instance for a version of the ServerHello message type
	 * 
	 * @param messageVersion
	 *            the Version indicator of the message type
	 * @param introducedInSiraPriseVersion
	 *            the SIRA_PRISE specification version in which this message type (version !) was introduced.
	 */
	ServerHelloMessageType (Version messageVersion, Version introducedInSiraPriseVersion) {
		super(MESSAGETYPEID, messageVersion, introducedInSiraPriseVersion);
	}

	/**
	 * Factory method to produce a ServerHello message of this version of the message type
	 * 
	 * @param signingProtocol
	 *            The message signing protocol elected by the server from the set of signing protocols proposed by the client
	 * @param encryptionDecryptionProtocol
	 *            The encryption protocol elected by the server from the set of encryption protocols proposed by the client
	 * @param idleTime
	 *            The time in milliseconds that the server will allow this connection to remain idle
	 * @param clientSiraPriseVersion
	 *            The SIRA_PRISE version that the client must use for communication.
	 * @param alternativeSigningProtocols
	 *            The set of alternative signing protocols that the server can handle (in addition to the elected signingProtocol) for user authentication
	 * @return A ServerHello message with the given data, of the appropriate version
	 */
	public abstract ServerHelloMessage message (Signature signingProtocol, ProprietaryOrJCECipher encryptionDecryptionProtocol, long idleTime, Version clientSiraPriseVersion, Set<String> alternativeSigningProtocols);
}
