/*
 * Created on 24-jul-2008
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.Version;

/**
 * A ServerOutputMessageType defines a type of message that can be sent by a SIRA_PRISE engine to a SIRA_PRISE client
 * 
 * @author Erwin Smout
 */
abstract class ServerOutputMessageType extends ServerMessageType {

	/**
	 * Creates the instance for some version of a Server Output Message type
	 * 
	 * @param messageTypeID
	 *            the numeric ID of a particular message type
	 * @param messageVersion
	 *            the Version indicator of the message type
	 * @param introducedInSiraPriseVersion
	 *            Gets the SIRA_PRISE specification version in which this message type (version !) was introduced.
	 */
	ServerOutputMessageType (int messageTypeID, Version messageVersion, Version introducedInSiraPriseVersion) {
		super(messageTypeID, messageVersion, introducedInSiraPriseVersion);
	}

}
