/*
 * Created on 29-jul-2008
 */
package be.SIRAPRISE.messages;

import be.erwinsmout.MyMessageFormat;

/**
 * @author Erwin Smout
 */
public abstract class SiraPriseErrorMessage extends ServerErrorMessage {

	/**
	 * 
	 */
	private static final String errorClass = Messages.getString("SiraPriseErrorMessage.ErrorClassDescription"); //$NON-NLS-1$

	/**
	 * Creates the ErrorMessage object, formatting and setting the appropriate clientResponseText
	 * 
	 * @param type
	 *            The SIRA_PRISE error message type
	 * @param errorNumber
	 *            The SIRA_PRISE runtime error number
	 * @param originalExceptionMessage
	 *            the server's original exception message
	 * @param fatal
	 *            Flag indicating whether the error was 'fatal', i.e. whether the server has aborted its side of the transaction as a consequence of the error
	 */
	SiraPriseErrorMessage (SiraPriseErrorMessageType type, long errorNumber, String originalExceptionMessage, boolean fatal) {
		super(type, errorNumber, MyMessageFormat.format(Messages.getString("SiraPriseErrorMessage.DBExceptionMessage"), new String[] { Long.toString(errorNumber), originalExceptionMessage }), originalExceptionMessage, fatal); //$NON-NLS-1$
	}

	public final String getErrorClass ( ) {
		return errorClass;
	}
}