/*
 * Created on 29-jul-2008
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.Version;

/**
 * The SiraPriseErrorMessageType is the message type returned by a SIRA_PRISE server in the event when any command issued by a client has resulted in a runtime error.
 * 
 * @author Erwin Smout
 */
public abstract class SiraPriseErrorMessageType extends ErrorMessageType {

	/**
	 * Comment for <code>MESSAGETYPEID</code>
	 */
	public static final int MESSAGETYPEID = 0x59478261;

	/**
	 * Creates the instance of some version of this type
	 * 
	 * @param messageVersion
	 *            the Version indicator of the message type
	 * @param introducedInSiraPriseVersion
	 *            Gets the SIRA_PRISE specification version in which this message type (version !) was introduced.
	 */
	SiraPriseErrorMessageType (Version messageVersion, Version introducedInSiraPriseVersion) {
		super(MESSAGETYPEID, messageVersion, introducedInSiraPriseVersion);
	}

	/**
	 * Factory method for producing messages of this version of the message type, holding the given SIRA_PRISE runtime error description
	 * 
	 * @param errorNumber
	 *            The numeric ID of the runtime exception that occurred
	 * @param message
	 *            The (formatted) error message as displayed to the client by SIRA_PRISE
	 * @return A SiraPriseErrorMessage of the appropriate version reflecting the given errorNumber and error message
	 */
	public final SiraPriseErrorMessage message (long errorNumber, String message) {
		return message(errorNumber, message, false);
	}

	/**
	 * Factory method for producing messages of this version of the message type, holding the given SIRA_PRISE runtime error description
	 * 
	 * @param errorNumber
	 *            The numeric ID of the runtime exception that occurred
	 * @param message
	 *            The (formatted) error message as displayed to the client by SIRA_PRISE
	 * @param fatal
	 *            Indicates whether the exception was 'fatal', i.e. whether the server aborted its transaction as a consequence of the error
	 * @return A SiraPriseErrorMessage of the appropriate version reflecting the given errorNumber and error message
	 */
	public abstract SiraPriseErrorMessage message (long errorNumber, String message, boolean fatal);

}