/*
 * Created on 29-jul-2008
 */
package be.SIRAPRISE.messages;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.util.MyDataInputStream;
import be.SIRAPRISE.util.MyDataOutputStream;

/**
 * SiraPriseErrorMessageTypeV1_1 is V1_1 of the SiraPriseErrorMessageType.
 * <p>
 * This message has the following fields :
 * </p>
 * 
 * <table border="1" cellpadding="2" cellspacing="1" width="100%">
 * <tbody>
 * <tr>
 * <th width="24%">one</th>
 * <th width="12%">Format</th>
 * <th width="9%">Length</th>
 * <th width="55%">Description</th>
 * </tr>
 * <tr>
 * <td>ERRORNUMBER</td>
 * <td>INTEGER</td>
 * <td>8</td>
 * <td>The number identifying the type of SIRA_PRISE runtime error.</td>
 * </tr>
 * <tr>
 * <td>ERRORMESSAGE</td>
 * <td>STRING</td>
 * <td>&nbsp;</td>
 * <td>The error message explaining the error.</td>
 * </tr>
 * <tr>
 * <td>FATALINDICATOR</td>
 * <td>INT</td>
 * <td>1</td>
 * <td>Nonzero if the server autonomously decided to abort (its side of) the (main) transaction as a consequence of the error. Zero if the main transaction is still active.</td>
 * </tr>
 * </tbody>
 * </table>
 * 
 * @author Erwin Smout
 * @since SIRA_PRISE 1.1
 */
public final class SiraPriseErrorMessageTypeV1_1 extends SiraPriseErrorMessageType {

	/**
	 * the instance
	 */
	private static SiraPriseErrorMessageType instance = new SiraPriseErrorMessageTypeV1_1();

	/**
	 * 
	 */
	private static final int MAXIMUMERRORMESSAGELENGTH = 8192;

	/**
	 * Gets the instance
	 * 
	 * @return the instance
	 */
	static SiraPriseErrorMessageType getInstance ( ) {
		return instance;
	}

	/**
	 * 
	 */
	private SiraPriseErrorMessageTypeV1_1 ( ) {
		super(Version.ONE_ONE, Version.ONE_FOUR);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificFromStream(java.io.DataInputStream)
	 */
	ServerMessage typeSpecificFromStream (DataInputStream in) throws IOException {
		long siraPriseErrorNumber = in.readLong();
		String exceptionMessage = MyDataInputStream.getSmallUTFString(in);
		byte fatal = in.readByte();
		return new SiraPriseErrorMessageV1_1(siraPriseErrorNumber, exceptionMessage, fatal != 0);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificToStream(be.erwinsmout.SIRA_PRISE.client.ServerMessage, java.io.DataOutputStream)
	 */
	void typeSpecificToStream (ServerMessage message, DataOutputStream outputStream) throws IOException {
		if (!(message instanceof SiraPriseErrorMessageV1_1)) {
			throw new IllegalArgumentException();
		}

		SiraPriseErrorMessageV1_1 siraPriseErrorMessageV1_1 = (SiraPriseErrorMessageV1_1) message;

		outputStream.writeLong(siraPriseErrorMessageV1_1.getErrorNumber());
		MyDataOutputStream.writeSmallUTF(siraPriseErrorMessageV1_1.getOriginalExceptionMessage(), outputStream);
		outputStream.writeByte(siraPriseErrorMessageV1_1.isFatal() ? 1 : 0);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.SiraPriseErrorMessageType#message(long, java.lang.String)
	 */
	public SiraPriseErrorMessage message (long errorNumber, String message, boolean fatal) {
		return new SiraPriseErrorMessageV1_1(errorNumber, message.substring(0, Math.min(message.length(), MAXIMUMERRORMESSAGELENGTH)), fatal);
	}
}