/*
 * Created on 29-jul-2008
 */
package be.SIRAPRISE.messages;

/**
 * @author Erwin Smout
 */
public abstract class StartSubTransactionMessage extends ServerInputMessage {

	/**
	 * flag indicating whether or not the new transaction is a read-only one, i.e. whether it will or will not attempt updates to the database
	 */
	private boolean readOnlyTransaction;

	/**
	 * For read-only transactions, indicates whether or not the read locks acquired by the server can be release after each individual statement executed by the transaction
	 */
	private boolean autoCommit;

	/**
	 * Creates a StartSubTransaction message
	 * 
	 * @param type
	 *            The MessageType object representing the type (and version of type) this new Message is of
	 * @param autoCommit
	 *            flag indicating whether each individual statement in the transaction is to be committed automatically
	 * @param readOnlyTransaction
	 *            flag indicating whether or not the new transaction is a read-only one, i.e. whether it will or will not attempt updates to the database
	 */
	StartSubTransactionMessage (StartSubTransactionMessageType type, boolean readOnlyTransaction, boolean autoCommit) {
		super(type);
		this.readOnlyTransaction = readOnlyTransaction;
		this.autoCommit = autoCommit;
	}

	/**
	 * Checks whether or not the new transaction is a read-only one, i.e. whether it will or will not attempt updates to the database
	 * 
	 * @return true if the new transaction is a read-only one, i.e. if it will not attempt updates to the database
	 */
	public final boolean isReadOnlyTransaction ( ) {
		return readOnlyTransaction;
	}

	/**
	 * Checks whether each individual statement in the transaction is to be committed automatically
	 * 
	 * @return true if each individual statement in the transaction is to be committed automatically
	 */
	public final boolean isAutoCommit ( ) {
		return autoCommit;
	}

}
