/*
 * Created on 29-jul-2008
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.Version;

/**
 * The StartSubTransactionMessageType is the type of message sent by a client to a SIRA_PRISE server if that client wants to establish a transaction savepoint and start a "nested" transaction within the currently running transaction.
 * 
 * @author Erwin Smout
 */
public abstract class StartSubTransactionMessageType extends ServerInputMessageType {

	/**
	 * Comment for <code>MESSAGETYPEID</code>
	 */
	public static final int MESSAGETYPEID = 0x50218a75;

	/**
	 * Creates an instance for some version of this message type
	 * 
	 * @param messageVersion
	 *            The Version of the messagetype being instantiated
	 * @param introducedInSiraPriseVersion
	 *            The SIRA_PRISE Version number in which this message Version was introduced
	 */
	StartSubTransactionMessageType (Version messageVersion, Version introducedInSiraPriseVersion) {
		super(MESSAGETYPEID, messageVersion, introducedInSiraPriseVersion);
	}

	/**
	 * Gets a StartSubTransactionMessage of this MessageType's version, holding the given data
	 * 
	 * @param readOnlyTransaction
	 *            flag indicating whether or not the new transaction is a read-only one, i.e. whether it will or will not attempt updates to the database
	 * @param autoCommit
	 *            flag indicating whether or not the server may automatically commit each individual statement executed in this transaction.
	 * @return StartTransactionMessage a StartTransactionMessage of this MessageType's version, holding the given data
	 */
	public abstract StartSubTransactionMessage message (boolean readOnlyTransaction, boolean autoCommit);

}
