/*
 * Created on 29-jul-2008
 */
package be.SIRAPRISE.messages;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import be.SIRAPRISE.client.Version;

/**
 * StartSubTransactionMessageTypeV1_0 is V1_0 of the StartSubTransactionMessageType.
 * <P>
 * This message has the following fields :
 * </P>
 * 
 * <table border="1" cellpadding="2" cellspacing="1" width="100%">
 * <tbody>
 * <tr>
 * <th width="24%">Zone</th>
 * <th width="12%">Format</th>
 * <th width="9%">Length</th>
 * <th width="55%">Description</th>
 * </tr>
 * <tr>
 * <td>READONLYTRANSACTION</td>
 * <td>INTEGER</td>
 * <td>1</td>
 * <td>1 if the transaction will not be doing any updates, and can therefore operate in read-only mode,<br>
 * 0 if the transaction is to perform updates on the database. This requires that the current transaction is also an update transaction. Update transactions cannot be nested within read-only transactions.</td>
 * </tr>
 * <tr>
 * <td>AUTOCOMMIT</td>
 * <td>INTEGER</td>
 * <td>1</td>
 * <td>1 if the server is required to commit every individual command sent to this transaction,<br>
 * 0 if the server is to commit this transaction only at the client's explicit request.</td>
 * </tr>
 * </tbody>
 * </table>
 * 
 * @author Erwin Smout
 * @since SIRA_PRISE 1.2
 */
public final class StartSubTransactionMessageTypeV1_0 extends StartSubTransactionMessageType {

	/**
	 * the instance
	 */
	private static StartSubTransactionMessageType instance = new StartSubTransactionMessageTypeV1_0();

	/**
	 * Gets the instance
	 * 
	 * @return the instance
	 */
	static StartSubTransactionMessageType getInstance ( ) {
		return instance;
	}

	/**
	 * 
	 */
	private StartSubTransactionMessageTypeV1_0 ( ) {
		super(Version.ONE_ZERO, Version.ONE_TWO);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificFromStream(java.io.DataInputStream)
	 */
	ServerMessage typeSpecificFromStream (DataInputStream in) throws IOException {
		boolean readOnlyTransaction = (in.readByte() == 1);
		boolean transactionWithStatementLevelLockRelease = (in.readByte() == 1);

		return new StartSubTransactionMessageV1_0(this, readOnlyTransaction, transactionWithStatementLevelLockRelease);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificToStream(be.erwinsmout.SIRA_PRISE.client.ServerMessage, java.io.DataOutputStream)
	 */
	void typeSpecificToStream (ServerMessage message, DataOutputStream outputStream) throws IOException {
		if (!(message instanceof StartSubTransactionMessageV1_0)) {
			throw new IllegalArgumentException();
		}

		StartSubTransactionMessageV1_0 startTransactionMessageV1_1 = (StartSubTransactionMessageV1_0) message;

		outputStream.writeByte(startTransactionMessageV1_1.isReadOnlyTransaction() ? 1 : 0);
		outputStream.writeByte(startTransactionMessageV1_1.isAutoCommit() ? 1 : 0);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.messages.StartTransactionMessageType#message(java.lang.String, boolean, java.lang.String, byte[])
	 */
	public StartSubTransactionMessage message (boolean readOnlyTransaction, boolean transactionWithStatementLevelLockRelease) {
		return new StartSubTransactionMessageV1_0(this, readOnlyTransaction, transactionWithStatementLevelLockRelease);
	}
}
