/*
 * Created on 29-jul-2008
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.Version;

/**
 * The StartTransactionMessageType is the message type to be sent by clients who wish to start a transaction on the server to do some data manipulation activity.
 * 
 * @author Erwin Smout
 */
public abstract class StartTransactionMessageType extends ServerInputMessageType {

	/**
	 * Comment for <code>MESSAGETYPEID</code>
	 */
	public static final int MESSAGETYPEID = 0x51881764;

	/**
	 * Creates an instance for some version of this message type
	 * 
	 * @param messageVersion
	 *            The Version of the messagetype being instantiated
	 * @param introducedInSiraPriseVersion
	 *            The SIRA_PRISE Version number in which this message Version was introduced
	 */
	StartTransactionMessageType (Version messageVersion, Version introducedInSiraPriseVersion) {
		super(MESSAGETYPEID, messageVersion, introducedInSiraPriseVersion);
	}

	/**
	 * Factory method for getting a StartTransactionMessage of this MessageType's version, holding the given data
	 * 
	 * @param userID
	 *            The identification of the user owning the new transaction
	 * @param userAuthenticatedByClient
	 *            indicates whether the user owning the new transaction has been authenticated by the client
	 * @param signatureAlgorithm
	 *            name of the user authentication algorithm to be used by the server if the decides that it will do user authentication itself
	 * @param signature
	 *            The signature to be verified by the server if the decides that it will do user authentication itself
	 * @param readOnlyTransaction
	 *            flag indicating whether or not the new transaction is a read-only one, i.e. whether it will or will not attempt updates to the database. Must be false if this message is sent to a server prior to 1.2
	 * @param autoCommit
	 *            flag indicating whether each individual statement is automatically committed (meaning, for a read-only transaction, that locks will immediately be released when the statement completes)
	 * @param captureDDL
	 *            flag indicating whether any DDL executed in this transaction should be captured by the server in a script. If set, a script file will be created by the server holding all the DDL executed in this transaction. For anonymous transactions, the file will be written in the server's user.home directory, and will be given the name of the internal transaction ID, followed by "DDL.SPS". For non-anonymous transactions, a directory will be created in the server's user.home directory, named after the user owning the transaction, and the script file will be written in that directory.
	 * @return StartTransactionMessage a StartTransactionMessage of this MessageType's version, holding the given data
	 */
	public abstract StartTransactionMessage message (String userID, boolean userAuthenticatedByClient, String signatureAlgorithm, byte[] signature, boolean readOnlyTransaction, boolean autoCommit, DDLCapture captureDDL);

	/**
	 * Factory method for getting a StartTransactionMessage of this MessageType's version, holding the given data
	 * 
	 * @param userID
	 *            The identification of the user owning the new transaction
	 * @param userAuthenticatedByClient
	 *            indicates whether the user owning the new transaction has been authenticated by the client
	 * @param signatureAlgorithm
	 *            name of the user authentication algorithm to be used by the server if the decides that it will do user authentication itself
	 * @param signature
	 *            The signature to be verified by the server if the decides that it will do user authentication itself
	 * @param readOnlyTransaction
	 *            flag indicating whether or not the new transaction is a read-only one, i.e. whether it will or will not attempt updates to the database. Must be false if this message is sent to a server prior to 1.2
	 * @param autoCommit
	 *            flag indicating whether each individual statement is automatically committed (meaning, for a read-only transaction, that locks will immediately be released when the statement completes)
	 * @return StartTransactionMessage a StartTransactionMessage of this MessageType's version, holding the given data
	 * @deprecated
	 */
	public final StartTransactionMessage message (String userID, boolean userAuthenticatedByClient, String signatureAlgorithm, byte[] signature, boolean readOnlyTransaction, boolean autoCommit) {
		return message(userID, userAuthenticatedByClient, signatureAlgorithm, signature, readOnlyTransaction, autoCommit, DDLCapture.OFF);
	}

	/**
	 * Gets a StartTransactionMessage of this MessageType's version, holding the given data
	 * 
	 * @param userID
	 *            The identification of the user owning the new transaction
	 * @param userAuthenticatedByClient
	 *            indicates whether the user owning the new transaction has been authenticated by the client
	 * @param signatureAlgorithm
	 *            name of the user authentication algorithm to be used by the server if the decides that it will do user authentication itself
	 * @param signature
	 *            The signature to be verified by the server if the decides that it will do user authentication itself
	 * @return StartTransactionMessage a StartTransactionMessage of this MessageType's version, holding the given data
	 * @deprecated
	 */
	public final StartTransactionMessage message (String userID, boolean userAuthenticatedByClient, String signatureAlgorithm, byte[] signature) {
		return message(userID, userAuthenticatedByClient, signatureAlgorithm, signature, false, false, DDLCapture.OFF);
	}
}
