/*
 * Created on 29-jul-2008
 */
package be.SIRAPRISE.messages;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.util.MyDataInputStream;
import be.SIRAPRISE.util.MyDataOutputStream;

/**
 * StartTransactionMessageTypeV1_2 is V1_2 of the StartTransactionMessageType.
 * <P>
 * This message has the following fields :
 * </P>
 * 
 * <table border="1" cellpadding="2" cellspacing="1" width="100%">
 * <tbody>
 * <tr>
 * <th width="24%">Zone</th>
 * <th width="12%">Format</th>
 * <th width="9%">Length</th>
 * <th width="55%">Description</th>
 * </tr>
 * <tr>
 * <td>USERID</td>
 * <td>STRING</td>
 * <td>&nbsp;</td>
 * <td>The name of the user starting the transaction. Can be the zero-length string, but if not, it must be a name that appears in some tuple of the USER relvar.</td>
 * </tr>
 * <tr>
 * <td>AUTHBYCLIENT</td>
 * <td>INTEGER</td>
 * <td>1</td>
 * <td>1 if the client has authenticated the user, 0 otherwise.</td>
 * </tr>
 * <tr>
 * <td>AUTHALGORITHM</td>
 * <td>STRING</td>
 * <td>&nbsp;</td>
 * <td>The name of the signing algorithm used to compute SIGNATURE. Can be the zero-length string.</td>
 * </tr>
 * <tr>
 * <td>SIGNATURELENGTH</td>
 * <td>INTEGER</td>
 * <td>2</td>
 * <td>The number of bytes in SIGNATURE. Can be zero, in which case the SIGNATURE field is omitted from the message.</td>
 * </tr>
 * <tr>
 * <td>SIGNATURE</td>
 * <td>BYTES</td>
 * <td>&nbsp;</td>
 * <td>The signature as computed by the signature algorithm identified by AUTHALGORITHM, using the user's private key corresponding to the public key that is registered for the user in the USERCERTIFICATE relvar, and applied to the USERID field.</td>
 * </tr>
 * <tr>
 * <td>READONLYTRANSACTION</td>
 * <td>INTEGER</td>
 * <td>1</td>
 * <td>1 if the transaction will not be doing any updates, and can therefore operate in read-only mode,<br>
 * 0 if the transaction is to perform updates on the database.</td>
 * </tr>
 * <tr>
 * <td>AUTOCOMMIT</td>
 * <td>INTEGER</td>
 * <td>1</td>
 * <td>1 if the server is required to commit every individual command sent to the transaction,<br>
 * 0 if the server is to commit this transaction only at the client's explicit request.</td>
 * </tr>
 * <tr>
 * <td>CAPTUREDDL</td>
 * <td>INTEGER</td>
 * <td>1</td>
 * <td>1 if the server is requested to activate its DDL capturing facility for this transaction,<br>
 * 0 if not.</td>
 * </tr>
 * </tbody>
 * </table>
 * 
 * @author Erwin Smout
 * @since SIRA_PRISE 1.3
 */
public final class StartTransactionMessageTypeV1_2 extends StartTransactionMessageType {

	/**
	 * the instance
	 */
	private static StartTransactionMessageType instance = new StartTransactionMessageTypeV1_2();

	/**
	 * Gets the instance
	 * 
	 * @return the instance
	 */
	static StartTransactionMessageType getInstance ( ) {
		return instance;
	}

	/**
	 * 
	 */
	private StartTransactionMessageTypeV1_2 ( ) {
		super(Version.ONE_TWO, Version.ONE_THREE);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificFromStream(java.io.DataInputStream)
	 */
	ServerMessage typeSpecificFromStream (DataInputStream in) throws IOException {
		String userID = MyDataInputStream.getSmallUTFString(in);
		boolean authenticatedByClient = (in.readByte() == 1);
		String userAuthenticationAlgorithm = MyDataInputStream.getSmallUTFString(in);
		short signatureLength = in.readShort();
		byte[] signature = new byte[signatureLength];
		in.read(signature);
		boolean readOnlyTransaction = (in.readByte() == 1);
		boolean transactionWithStatementLevelLockRelease = (in.readByte() == 1);
		boolean captureDDL = (in.readByte() == 1);

		return new StartTransactionMessageV1_2(this, userID, authenticatedByClient, userAuthenticationAlgorithm, signature, readOnlyTransaction, transactionWithStatementLevelLockRelease, captureDDL);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificToStream(be.erwinsmout.SIRA_PRISE.client.ServerMessage, java.io.DataOutputStream)
	 */
	void typeSpecificToStream (ServerMessage message, DataOutputStream outputStream) throws IOException {
		if (!(message instanceof StartTransactionMessageV1_2)) {
			throw new IllegalArgumentException();
		}

		StartTransactionMessageV1_2 startTransactionMessageV1_2 = (StartTransactionMessageV1_2) message;

		MyDataOutputStream.writeSmallUTF(startTransactionMessageV1_2.getUserID(), outputStream);
		outputStream.writeByte(startTransactionMessageV1_2.isUserAuthenticatedByClient() ? 1 : 0);
		MyDataOutputStream.writeSmallUTF(startTransactionMessageV1_2.getUserAuthenticationAlgorithm(), outputStream);
		byte[] signature = startTransactionMessageV1_2.getSignature();
		outputStream.writeShort(signature.length);
		outputStream.write(signature);
		outputStream.writeByte(startTransactionMessageV1_2.isReadOnlyTransaction() ? 1 : 0);
		outputStream.writeByte(startTransactionMessageV1_2.isAutoCommit() ? 1 : 0);
		outputStream.writeByte(startTransactionMessageV1_2.isCaptureDDL() ? 1 : 0);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.messages.StartTransactionMessageType#message(java.lang.String, boolean, java.lang.String, byte[])
	 */
	public StartTransactionMessage message (String userID, boolean userAuthenticatedByClient, String signatureAlgorithm, byte[] signature, boolean readOnlyTransaction, boolean autoCommit, DDLCapture captureDDL) {
		return new StartTransactionMessageV1_2(this, userID, userAuthenticatedByClient, signatureAlgorithm, signature, readOnlyTransaction, autoCommit, captureDDL.isCapturingDDL());
	}
}
