/*
 * Created on 29-jul-2008
 */
package be.SIRAPRISE.messages;

/**
 * @author Erwin Smout
 */
final class StartTransactionMessageV1_1 extends StartTransactionMessage {

	/**
	 * @param type
	 *            The Message Type of the message being instantiated
	 * @param userID
	 *            The identification of the user owning the new transaction
	 * @param userAuthenticatedByClient
	 *            indicates whether the user owning the new transaction has been authenticated by the client
	 * @param userAuthenticationAlgorithm
	 *            name of the user authentication algorithm to be used by the server if the decides that it will do user authentication itself
	 * @param signature
	 *            The signature to be verified by the server if the decides that it will do user authentication itself
	 * @param readOnlyTransaction
	 *            flag indicating whether or not the new transaction is a read-only one, i.e. whether it will or will not attempt updates to the database
	 * @param autoCommit
	 *            flag indicating whether each individual statement is automatically committed (meaning, for a read-only transaction, that locks will immediately be released when the statement completes)
	 */
	StartTransactionMessageV1_1 (StartTransactionMessageTypeV1_1 type, String userID, boolean userAuthenticatedByClient, String userAuthenticationAlgorithm, byte[] signature, boolean readOnlyTransaction, boolean autoCommit) {
		super(type, userID, userAuthenticatedByClient, userAuthenticationAlgorithm, signature, readOnlyTransaction, autoCommit, false);
	}

}
