/*
 * Created on 3-aug-2008
 */
package be.SIRAPRISE.messages;

/**
 * @author Erwin Smout
 */
public abstract class TransactionEndedMessage extends ServerOutputMessage {

	/**
	 * Flag indicating whether the transaction must be ended with a commit or a rollback
	 */
	private boolean commit;

	/**
	 * @param commit
	 * @param type
	 */
	TransactionEndedMessage (boolean commit, TransactionEndedMessageType type) {
		super(type);
		this.commit = commit;
	}

	/**
	 * Indicates whether the transaction must be ended with a commit or a rollback
	 * 
	 * @return true if the transaction must be ended with a commit
	 */
	public boolean isCommit ( ) {
		return commit;
	}
}
