/*
 * Created on 3-aug-2008
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.Version;

/**
 * The TransactionEndedMessageType is the type of message sent by a server in response to an EndTransaction message
 * 
 * @author Erwin Smout
 */
public abstract class TransactionEndedMessageType extends ServerOutputMessageType {

	/**
	 * Comment for <code>MESSAGETYPEID</code>
	 */
	public static final int MESSAGETYPEID = 0x018E1DED;

	/**
	 * Creates the instance of some version of this message type
	 * 
	 * @param messageVersion
	 *            the Version indicator of the message type
	 * @param introducedInSiraPriseVersion
	 *            the SIRA_PRISE specification version in which this message type (version !) was introduced.
	 */
	TransactionEndedMessageType (Version messageVersion, Version introducedInSiraPriseVersion) {
		super(MESSAGETYPEID, messageVersion, introducedInSiraPriseVersion);
	}

	/**
	 * Factory method for getting messages of this version of the message type
	 * 
	 * @param commit
	 *            true if the ended transaction was also committed, false if that transaction was rolled back
	 * @return A TransactionEndedMessage of the corresponding version/type
	 */
	public abstract TransactionEndedMessage message (boolean commit);

}
