/*
 * Created on 4-aug-2008
 */
package be.SIRAPRISE.messages;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import be.SIRAPRISE.client.Version;

/**
 * TransactionEndedMessageTypeV1_0 is V1_0 of the TransactionEndedMessageType.
 * <P>
 * This message has the following fields :
 * </P>
 * <table border="1" cellpadding="2" cellspacing="1" width="100%">
 * <tbody>
 * <tr>
 * <th width="24%">Zone</th>
 * <th width="12%">Format</th>
 * <th width="9%">Length</th>
 * <th width="55%">Description</th>
 * </tr>
 * <tr>
 * <td>COMMIT</td>
 * <td>INTEGER</td>
 * <td>1</td>
 * <td>1 if the transaction was committed, 0 if it was rolled back.</td>
 * </tr>
 * </tbody>
 * </table>
 * 
 * @author Erwin Smout
 * @since SIRA_PRISE 1.1
 */
public final class TransactionEndedMessageTypeV1_0 extends TransactionEndedMessageType {

	/**
	 * the instance
	 */
	private static ServerMessageType instance = new TransactionEndedMessageTypeV1_0();

	/**
	 * Gets the instance
	 * 
	 * @return the instance
	 */
	static ServerMessageType getInstance ( ) {
		return instance;
	}

	/**
     * 
     */
	private TransactionEndedMessageTypeV1_0 ( ) {
		super(Version.ONE_ZERO, Version.ONE_ZERO);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificFromStream(java.io.DataInputStream)
	 */
	ServerMessage typeSpecificFromStream (DataInputStream in) throws IOException {
		boolean commit = (in.readByte() == CommitRollbackMessageType.COMMIT);
		return new TransactionEndedMessageV1_0(this, commit);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificToStream(be.erwinsmout.SIRA_PRISE.client.ServerMessage, java.io.DataOutputStream)
	 */
	void typeSpecificToStream (ServerMessage message, DataOutputStream outputStream) throws IOException {
		if (!(message instanceof TransactionEndedMessageV1_0)) {
			throw new IllegalArgumentException();
		}

		TransactionEndedMessageV1_0 transactionEndedMessageV1_0 = (TransactionEndedMessageV1_0) message;

		outputStream.writeByte(transactionEndedMessageV1_0.isCommit() ? CommitRollbackMessageType.COMMIT : CommitRollbackMessageType.ROLLBACK);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.TransactionEndedMessageType#message(boolean)
	 */
	public TransactionEndedMessage message (boolean commit) {
		return new TransactionEndedMessageV1_0(this, commit);
	}

}
