/*
 * Created on 29-jul-2008
 */
package be.SIRAPRISE.messages;

/**
 * @author Erwin Smout
 */
public abstract class TransactionStartedMessage extends ServerOutputMessage {

	/**
	 * The identification of the started transaction
	 */
	private long transactionID;

	/**
	 * @param type
	 * @param transactionID
	 *            The numerical identification of the transaction started on the server
	 */
	TransactionStartedMessage (TransactionStartedMessageType type, long transactionID) {
		super(type);
		this.transactionID = transactionID;
	}

	/**
	 * Gets The identification of the started transaction
	 * 
	 * @return The identification of the started transaction
	 */
	public final long getTransactionID ( ) {
		return transactionID;
	}
}
