/*
 * Created on 29-jul-2008
 */
package be.SIRAPRISE.messages;

import be.SIRAPRISE.client.Version;

/**
 * The TransactionStartedMessageType is the message type sent by servers in response to a StartTransaction or StartSubTransaction message type
 * 
 * @author Erwin Smout
 */
public abstract class TransactionStartedMessageType extends ServerOutputMessageType {

	/**
	 * Comment for <code>MESSAGETYPEID</code>
	 */
	public static final int MESSAGETYPEID = 0x1FABB1ED;

	/**
	 * Creates the instance of some version of this message type
	 * 
	 * @param messageVersion
	 *            the Version indicator of the message type
	 * @param introducedInSiraPriseVersion
	 *            the SIRA_PRISE specification version in which this message type (version !) was introduced.
	 */
	TransactionStartedMessageType (Version messageVersion, Version introducedInSiraPriseVersion) {
		super(MESSAGETYPEID, messageVersion, introducedInSiraPriseVersion);
	}

	/**
	 * Factory method for getting A TransactionStarted message of this version of the type
	 * 
	 * @return A TransactionStarted message
	 * @deprecated
	 */
	public final TransactionStartedMessage message ( ) {
		return message(-1);
	}

	/**
	 * Factory method for getting A TransactionStarted message of this version of the type
	 * 
	 * @param transactionID
	 *            The identification of the started transaction
	 * 
	 * @return A TransactionStarted message
	 */
	public abstract TransactionStartedMessage message (long transactionID);
}
