/*
 * Created on 29-jul-2008
 */
package be.SIRAPRISE.messages;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import be.SIRAPRISE.client.Version;

/**
 * TransactionStartedMessageTypeV1_1 is V1_1 of the TransactionStartedMessageType.
 * <P>
 * This message has the following fields :
 * </P>
 * <table border="1" cellpadding="2" cellspacing="1" width="100%">
 * <tbody>
 * <tr>
 * <th width="24%">Zone</th>
 * <th width="12%">Format</th>
 * <th width="9%">Length</th>
 * <th width="55%">Description</th>
 * </tr>
 * <tr>
 * <td>TRANSACTIONID</td>
 * <td>INTEGER</td>
 * <td>8</td>
 * <td>The numeric ID assigned by the server to this transaction. To be used by the client on every subsequent request to commit, rollback or end this transaction.</td>
 * </tr>
 * </tbody>
 * </table>
 * 
 * @author Erwin Smout
 * @since SIRA_PRISE 1.2
 */
public final class TransactionStartedMessageTypeV1_1 extends TransactionStartedMessageType {

	/**
	 * the instance
	 */
	private static ServerMessageType instance = new TransactionStartedMessageTypeV1_1();

	/**
	 * Gets the instance
	 * 
	 * @return the instance
	 */
	static ServerMessageType getInstance ( ) {
		return instance;
	}

	/**
	 * 
	 */
	private TransactionStartedMessageTypeV1_1 ( ) {
		super(Version.ONE_ONE, Version.ONE_TWO);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificFromStream(java.io.DataInputStream)
	 */
	ServerMessage typeSpecificFromStream (DataInputStream in) throws IOException {
		long transactionID = in.readLong();
		return new TransactionStartedMessageV1_1(this, transactionID);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.ServerMessageType#typeSpecificToStream(be.erwinsmout.SIRA_PRISE.client.ServerMessage, java.io.DataOutputStream)
	 */
	void typeSpecificToStream (ServerMessage message, DataOutputStream outputStream) throws IOException {
		if (!(message instanceof TransactionStartedMessageV1_1)) {
			throw new IllegalArgumentException();
		}

		TransactionStartedMessageV1_1 transactionStartedMessageV1_1 = (TransactionStartedMessageV1_1) message;

		outputStream.writeLong(transactionStartedMessageV1_1.getTransactionID());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.client.TransactionStartedMessageType#message()
	 */
	public TransactionStartedMessage message (long transactionID) {
		return new TransactionStartedMessageV1_1(this, transactionID);
	}

}
