/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The INT absolute value operator takes a single argument of type INT, and returns its absolute value.
 * 
 * @author Erwin
 */
public final class ABS_INT implements OperatorImplementation_V0104 {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.INT };

	/**
	 * The operator returns the absolute value of its argument. An exception is raised if the argument is equal to FIRSTINT().
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		int value = DbmsIntImplementation.getJavaInt((ScalarValueBuffer) args.get(0));
		if (value == Integer.MIN_VALUE) {
			throw new NumericOverflowException();
		}
		return DbmsIntImplementation.getValueBuffer(Math.abs(value));
	}

	/**
	 * The return type is INT
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.INT;
	}

	/**
	 * The operator takes a single argument of type INT
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
