/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The LONG absolute value operator takes a single argument of type LONG and returns its absolute value.
 * 
 * @author Erwin
 */
public final class ABS_LONG implements OperatorImplementation_V0104 {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.LONG };

	/**
	 * The operator returns the absolute value of the argument. An exception is raised if the argument is equal to FIRSTLONG().
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		long value = DbmsLongImplementation.getJavaLong((ScalarValueBuffer) args.get(0));
		if (value == Long.MIN_VALUE) {
			throw new NumericOverflowException();
		}
		return DbmsLongImplementation.getValueBuffer(Math.abs(value));
	}

	/**
	 * The return type is LONG.
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.LONG;
	}

	/**
	 * The argument is of type LONG.
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
