/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The ACOSEC operator takes a FLOAT argument and returns the ANGLE value to which the argument is the cosecant
 * 
 * @author Erwin
 */
public final class ACOSEC_FLOAT implements OperatorImplementation_V0104 {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.FLOAT };

	/**
	 * Returns the ANGLE value (in the range -PI/2 - PI/2) to which the argument is the cosecant.
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		double sineValue = 1.0 / DbmsFloatImplementation.getJavaDouble(args.get(0));
		if (sineValue < -1.0 || sineValue > 1.0)
			throw new IllegalArgumentException();
		return DbmsAngleImplementation.getAngleValueBuffer(Math.asin(sineValue));
	}

	/**
	 * The return type is ANGLE
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.ANGLE;
	}

	/**
	 * The single argument is of type FLOAT
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
