/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The ACOS operator takes a FLOAT argument and returns the ANGLE value of which this argument is the cosine.
 * 
 * @author Erwin
 */
public final class ACOS_FLOAT implements OperatorImplementation_V0104 {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.FLOAT };

	/**
	 * The operator returns the ANGLE value (in the range 0-PI) such that the argument is the cosine of this angle
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		double cosineValue = DbmsFloatImplementation.getJavaDouble(args.get(0));
		if (cosineValue < -1.0 || cosineValue > 1.0)
			throw new IllegalArgumentException();
		return DbmsAngleImplementation.getAngleValueBuffer(Math.acos(cosineValue));
	}

	/**
	 * ACOS returns an ANGLE value
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.ANGLE;
	}

	/**
	 * ACOS takes an argument of type FLOAT
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
