/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The implementation for the boolean AND operator.
 * 
 * @author Erwin
 */
public final class AND_BOOLEAN_BOOLEAN implements AggregationOperatorImplementation, BinaryBooleanOperatorImplementation {

	/**
	 * The argument type names
	 */
	private static final String[] argumentTypeNames = new String[] { TYPENAMES.BOOLEAN, TYPENAMES.BOOLEAN };

	/**
	 * 
	 */
	private static final AND_BOOLEAN_BOOLEAN instance = new AND_BOOLEAN_BOOLEAN();

	/**
	 * Gets instance
	 *
	 * @return instance.
	 */
	public static final AND_BOOLEAN_BOOLEAN getInstance ( ) {
		return instance;
	}

	/**
	 * Creates the AND_BOOLEAN_BOOLEAN
	 * 
	 */
	private AND_BOOLEAN_BOOLEAN ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.TypeImplementations.OperatorImplementation#executeOperator(java.util.LinkedList)
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return (DbmsBooleanImplementation.getJavaBoolean(((ScalarValueBuffer) args.get(0))) && DbmsBooleanImplementation.getJavaBoolean(((ScalarValueBuffer) args.get(1)))) ? DbmsBooleanImplementation.trueValue : DbmsBooleanImplementation.falseValue;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.OperatorImplementation#getArgumentTypes()
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypeNames;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.AssociativeOperatorImplementation#getIdentityElement()
	 */
	public ScalarValueBuffer getIdentityElement ( ) {
		return DbmsBooleanImplementation.trueValue;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.server.BinaryBooleanOperatorImplementation#getNegated(java.util.LinkedList)
	 */
	public String getNegated (String operand1, String operand2) {
		return "OR(NOT(" + operand1 + "),NOT(" + operand2 + "))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.TypeImplementations.OperatorImplementation#getReturnType()
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.BOOLEAN;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
