/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The ASEC operator returns the ANGLE value to which the argument is the secant.
 * 
 * @author Erwin
 */
public final class ASEC_FLOAT implements OperatorImplementation_V0104 {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.FLOAT };

	/**
	 * The operator returns the ANGLE value (in the range 0-PI) to which the argument is the secant.
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		double cosineValue = 1.0 / DbmsFloatImplementation.getJavaDouble(args.get(0));
		if (cosineValue < -1.0 || cosineValue > 1.0)
			throw new IllegalArgumentException();
		return DbmsAngleImplementation.getAngleValueBuffer(Math.acos(cosineValue));
	}

	/**
	 * The return type is ANGLE
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.ANGLE;
	}

	/**
	 * The argument is of type FLOAT
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
