/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The ASIN operator returns the ANGLE value to which the argument is the sine.
 * 
 * @author Erwin
 */
public final class ASIN_FLOAT implements OperatorImplementation_V0104 {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.FLOAT };

	/**
	 * The operator returns the ANGLE value (in the range -PI/2 - PI/2) to which the argument is the sine.
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		double sineValue = DbmsFloatImplementation.getJavaDouble(args.get(0));
		if (sineValue < -1.0 || sineValue > 1.0)
			throw new IllegalArgumentException();
		return DbmsAngleImplementation.getAngleValueBuffer(Math.asin(sineValue));
	}

	/**
	 * The return value is of type ANGLE
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.ANGLE;
	}

	/**
	 * The argument is of type FLOAT
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
