/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The implementation for the arctangent operator.
 * 
 * @author Erwin
 */
public final class ATAN_FLOAT implements OperatorImplementation_V0104 {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.FLOAT };

	/**
	 * The operator returns the ANGLE value (in the range -PI/2 - PI/2) to which the argument is the tangent.
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return DbmsAngleImplementation.getAngleValueBuffer(Math.atan(DbmsFloatImplementation.getJavaDouble(args.get(0))));
	}

	/**
	 * The return type is ANGLE
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.ANGLE;
	}

	/**
	 * The argument type is FLOAT
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
