/*
 * Created on 1-jun-2007
 */
package be.SIRAPRISE.typeimplementations;

/**
 * AggregationOperatorImplementation is the interface that must/can be implemented by all operator implementations that are both commutative and associative, meaning in particular :
 * <p>
 * <ol>
 * <li>The basic form of the operator is binary, i.e. it has two arguments.</li>
 * <li>Those arguments are of the same type.</li>
 * <li>The return type is the same as the arguments.</li>
 * <li>The mathematical property holds for this operator that for all a,b,c : ((a op b) op c) == (a op (b op c)).</li>
 * <li>The mathematical property of commutativity holds as well (i.e. for all a,c : (a op c) == (c op a)).</li>
 * </ol>
 * </p>
 * Sira_prise's aggregation operations on attribute values within relations can only be performed using operators that implement this interface. An operator such as e.g. String concatenation satisfies the property of associativity, but not that of commutativity. Such operators cannot be used in aggregation operations.
 * 
 * @author Erwin Smout
 */
public interface AggregationOperatorImplementation extends OperatorImplementation_V0104 {

	/**
	 * Gets the identity element of the operator in its domain.
	 * 
	 * @return The identity element.
	 * @throws NoIdentityElementException
	 *             if no such element exists within the (finite bounds of the) operator's domain.
	 */
	ScalarValueBuffer getIdentityElement ( ) throws NoIdentityElementException;

}