/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The BEGINSWITH operator takes two NAME arguments and returns true if all tokens in the second argument are identical to the tokens of the first argument in the corresponding position.
 * 
 * @author Erwin
 */
public final class BEGINSWITH_NAME_NAME implements OperatorImplementation_V0104 {

	/**
	 * The argument type names
	 */
	private static final String[] argumentTypeNames = new String[] { TYPENAMES.NAME, TYPENAMES.NAME };

	/**
	 * The operator returns true if the first argument starts with all the characters of the second argument.
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return DbmsNameImplementation.getJavaString(((ScalarValueBuffer) args.get(0))).startsWith(DbmsNameImplementation.getJavaString(((ScalarValueBuffer) args.get(1)))) ? DbmsBooleanImplementation.trueValue : DbmsBooleanImplementation.falseValue;
	}

	/**
	 * The operator takes two arguments, both of type NAME
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypeNames;
	}

	/**
	 * The return type is BOOLEAN
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.BOOLEAN;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
