/*
 * Created on 21-feb-2008
 */
package be.SIRAPRISE.typeimplementations;

/**
 * Interface to be implemented by all implementations of one of the 16 binary operators of the boolean algebra.
 * 
 * @author Erwin Smout
 */
public interface BinaryBooleanOperatorImplementation {

	/**
	 * Gets the expression that is the negation of an invocation of this operator implementation
	 * 
	 * @param operand1
	 *            The first operand of the invocation to be negated
	 * @param operand2
	 *            The second operand of the invocation to be negated
	 * 
	 * @return the expression that is the negation of an invocation of this operator implementation
	 */
	public String getNegated (String operand1, String operand2);

}
