/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * CEIL returns the smallest integer that is higher than or equal to the first argument and an exact multiple of the second. CEIL(5,2) = 6 CEIL(6,2) = 6 CEIL(-5,2) = -4 CEIL(-6,2) = -6 CEIL(a,b) = CEIL(a,-b)
 * 
 * @author Erwin
 */
public final class CEIL_INT_INT implements OperatorImplementation_V0104 {

	/**
	 * The argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.INT, TYPENAMES.INT };

	/**
	 * CEIL returns the smallest integer that is higher than or equal to the first argument and an exact multiple of the second. CEIL(5,2) = 6 CEIL(6,2) = 6 CEIL(-5,2) = -4 CEIL(-6,2) = -6 CEIL(a,b) = CEIL(a,-b)
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		final ScalarValueBuffer bb1 = (ScalarValueBuffer) args.get(0);
		long b1 = DbmsIntImplementation.getJavaInt(bb1);
		int unitValue = DbmsIntImplementation.getJavaInt((ScalarValueBuffer) args.get(1));
		if (unitValue == Integer.MIN_VALUE) {
			if (b1 < 1) {
				if (b1 == Integer.MIN_VALUE) {
					return bb1;
				} else {
					return DbmsIntImplementation.getValueBuffer(0);
				}
			} else {
				throw new NumericOverflowException();
			}
		}
		long b2 = Math.abs(unitValue);
		if (b1 > 0) {
			long mod = b1 % b2;
			if (mod == 0) {
				return DbmsIntImplementation.getValueBuffer((int) (b1));
			} else {
				long result = b1 - mod + b2;
				if (result > Integer.MAX_VALUE) {
					throw new NumericOverflowException();
				}
				return DbmsIntImplementation.getValueBuffer((int) (result));
			}
		} else {
			if (b1 == Integer.MIN_VALUE) {
				return DbmsIntImplementation.getValueBuffer(-Integer.MAX_VALUE);
			} else {
				long mod = -b1 % b2;
				if (mod == 0) {
					return DbmsIntImplementation.getValueBuffer((int) (b1));
				} else {
					return DbmsIntImplementation.getValueBuffer((int) (b1 + mod));
				}
			}
		}
	}

	/**
	 * The return type is INT
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.INT;
	}

	/**
	 * The operator takes two arguments, both of type INT
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
