/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * CEIL returns the smallest integer that is higher than or equal to the first argument and an exact multiple of the second. CEIL(5,2) = 6 CEIL(6,2) = 6 CEIL(-5,2) = -4 CEIL(-6,2) = -6 CEIL(a,b) = CEIL(a,-b)
 * 
 * @author Erwin
 */
public final class CEIL_LONG_LONG implements OperatorImplementation_V0104 {

	/**
	 * The argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.LONG, TYPENAMES.LONG };

	/**
	 * CEIL returns the smallest integer that is higher than or equal to the first argument and an exact multiple of the second. CEIL(5,2) = 6 CEIL(6,2) = 6 CEIL(-5,2) = -4 CEIL(-6,2) = -6 CEIL(a,b) = CEIL(a,-b)
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		final ScalarValueBuffer bb1 = (ScalarValueBuffer) args.get(0);
		long b1 = DbmsLongImplementation.getJavaLong(bb1);
		long unitValue = DbmsLongImplementation.getJavaLong((ScalarValueBuffer) args.get(1));
		if (unitValue == Long.MIN_VALUE) {
			if (b1 < 1) {
				if (b1 == Long.MIN_VALUE) {
					return bb1;
				} else {
					return DbmsLongImplementation.getValueBuffer(0);
				}
			} else {
				throw new NumericOverflowException();
			}
		}
		long b2 = Math.abs(unitValue);
		if (b1 > 0) {
			long mod = b1 % b2;
			if (mod == 0) {
				return DbmsLongImplementation.getValueBuffer(b1);
			} else {
				if (b1 - mod > Long.MAX_VALUE - b2) {
					throw new NumericOverflowException();
				}
				return DbmsLongImplementation.getValueBuffer(b1 - mod + b2);
			}
		} else {
			if (b1 == Long.MIN_VALUE) {
				return DbmsLongImplementation.getValueBuffer(-Long.MAX_VALUE);
			} else {
				long mod = -b1 % b2;
				if (mod == 0) {
					return DbmsLongImplementation.getValueBuffer(b1);
				} else {
					return DbmsLongImplementation.getValueBuffer(b1 + mod);
				}
			}
		}
	}

	/**
	 * The return type is LONG
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.LONG;
	}

	/**
	 * CEIL takes two arguments, both of type LONG
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
