/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * CONCAT returns the result of appending the second STRING argument to the first.
 * 
 * @author Erwin
 */
public final class CONCAT_STRING_STRING implements OperatorImplementation_V0104 {

	/**
	 * The argument type names
	 */
	private static final String[] argumentTypeNames = new String[] { TYPENAMES.STRING, TYPENAMES.STRING };

	/**
	 * CONCAT returns the result of appending the second STRING argument to the first.
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		try {
			return DbmsStringImplementation.getValueBuffer(DbmsStringImplementation.getJavaString(((ScalarValueBuffer) args.get(0))) + DbmsStringImplementation.getJavaString(((ScalarValueBuffer) args.get(1))));
		} catch (InvalidValueException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * CONCAT takes two arguments, both of type STRING
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypeNames;
	}

	/**
	 * CONCAT returns a STRING
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.STRING;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
