/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The COS operator returns the cosine of its argument.
 * 
 * @author Erwin
 */
public final class COS_ANGLE implements OperatorImplementation_V0104 {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.ANGLE };

	/**
	 * COS returns the cosine of its argument.
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return DbmsFloatImplementation.getValueBuffer(Math.cos(DbmsAngleImplementation.getJavaDouble((ScalarValueBuffer) args.get(0))));
	}

	/**
	 * The return type is FLOAT
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.FLOAT;
	}

	/**
	 * COS takes an argument of type ANGLE
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
