/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * COTAN returns the cotangent of its argument
 * 
 * @author Erwin
 */
public final class COTAN_ANGLE implements OperatorImplementation_V0104 {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.ANGLE };

	/**
	 * COTAN returns the cotangent of its argument
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return DbmsFloatImplementation.getValueBuffer(1.0 / Math.tan(DbmsAngleImplementation.getJavaDouble((ScalarValueBuffer) args.get(0))));
	}

	/**
	 * COTAN takes an argument of type ANGLE
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * COTAN returns a FLOAT
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.FLOAT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
