/*
 * Created on 15-jun-04
 */
package be.SIRAPRISE.typeimplementations;

import java.util.Calendar;

import java.util.GregorianCalendar;
import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The DATESHIFT operator computes a date that is a given quantity of days, months, years away from a given date
 * 
 * @author Erwin Smout
 */
public final class DATESHIFT_DATE_INT_INT_INT implements OperatorImplementation_V0104 {

	/**
	 * The argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.DATE, TYPENAMES.INT, TYPENAMES.INT, TYPENAMES.INT };

	/**
	 * Checks whether an end-of-month date has been shifted into a shorter month.
	 * 
	 * @param dd
	 *            The day value
	 * @param mm
	 *            The month in the JAVA range 0-11, NOT the normal range of 1-12 that any human user would expect ... Stupid java morons ...
	 * @return The day value to be applied as a result of correction after shifting an end-of-month date into a shorter month
	 */
	private int correctForLastDayOfMonth (int dd, int mm) {
		if (dd == 31) {
			if (mm == Calendar.APRIL || mm == Calendar.JUNE || mm == Calendar.SEPTEMBER || mm == Calendar.NOVEMBER) {
				return 30;
			}
		}
		return dd;
	}

	/**
	 * Checks whether a leap date has been shifted into a non-leap year.
	 * 
	 * @param dd
	 *            The day value
	 * @param mm
	 *            The month in the JAVA range 0-11, NOT the normal range of 1-12 that any human user would expect ... Stupid java morons ...
	 * @param yyyy
	 *            The year
	 * @return The day value to be applied as a result of correction after shifting a leap date into a non leap year
	 */
	private int correctForLeapDateInNonLeapYear (int dd, int mm, int yyyy) {
		int newdd = dd;
		// Check if new date has become "leap date in non-leap year"
		if (mm == Calendar.FEBRUARY && dd > 28) {
			if ((yyyy & 0x00000003) == 0) {
				// yyyy multiple of 4
				// still an error if a multiple of 100, but not of 400 (e.g. 1900)
				if (yyyy % 100 == 0) {
					if (yyyy % 400 == 0) {
						// multiple of 400 ===> 30 and 31 must become 29
						newdd = 29;
					} else {
						// options : correct forward, correct backward, IllegalArgumentException
						newdd = 28;
					}
				} else {
					// simple multiple of 4 ===> 30 and 31 must become 29
					newdd = 29;
				}
			} else {
				// yyyy no multiple of 4 ===> certainly not a leap year
				// options : correct forward, correct backward, IllegalArgumentException
				newdd = 28;
			}
		}
		return newdd;
	}

	/**
	 * The DATESHIFT operator computes a date that is a given quantity of days, months, years away from a given date
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		int date = DbmsIntImplementation.getJavaInt((ScalarValueBuffer) args.get(0));
		int years = DbmsIntImplementation.getJavaInt((ScalarValueBuffer) args.get(1));
		int months = DbmsIntImplementation.getJavaInt((ScalarValueBuffer) args.get(2));
		int days = DbmsIntImplementation.getJavaInt((ScalarValueBuffer) args.get(3));
		int dd = date & 0x0000001f;
		date = date >> 5;
		int mm = date % 12; // mm in the java range 0-11 !!!!!!!!! Stupid java idiots ..........
		int yyyy = date / 12;

		if (years == 0) {
			if (months == 0) {
				// Add days
				GregorianCalendar gregorianDate = new GregorianCalendar(yyyy, mm, dd);
				int julian = gregorianDate.get(Calendar.DAY_OF_YEAR); // range 1-366
				if (days >= 0) {
					int lastJulianOfYear = gregorianDate.isLeapYear(yyyy) ? 366 : 365;
					while (days + julian > lastJulianOfYear) {
						// Always shift to january, 1st of next year
						days -= (lastJulianOfYear + 1 - julian);
						julian = 1;
						gregorianDate.set(Calendar.DAY_OF_MONTH, 1);
						gregorianDate.set(Calendar.MONTH, Calendar.JANUARY);
						gregorianDate.set(Calendar.YEAR, ++yyyy);
						lastJulianOfYear = gregorianDate.isLeapYear(yyyy) ? 366 : 365;
					}
				} else {
					while (days + julian < 1) {
						// Always shift to december, 31st of previous year
						days += julian;
						gregorianDate.set(Calendar.MONTH, Calendar.DECEMBER);
						gregorianDate.set(Calendar.DAY_OF_MONTH, 31);
						gregorianDate.set(Calendar.YEAR, --yyyy);
						julian = gregorianDate.isLeapYear(yyyy) ? 366 : 365;
					}
				}

				gregorianDate.set(Calendar.DAY_OF_YEAR, days + julian);
//				yyyy = gregorianDate.get(Calendar.YEAR);  Because if the year has decreased to zero, then that stupid java implementation returns 1 instead (making it later impossible to raise the needed out-of-range exception)
				mm = gregorianDate.get(Calendar.MONTH);
				dd = gregorianDate.get(Calendar.DAY_OF_MONTH);
			} else {
				// months given
				if (days == 0) {
					years = months / 12;
					months %= 12; // -5 stays -5 ; -13 becomes -1
					yyyy += years;
					mm += months;
					if (mm > 11) {
						mm -= 12;
						yyyy++;
					} else {
						if (mm < 0) {
							mm += 12;
							yyyy--;
						}
					}
					dd = correctForLeapDateInNonLeapYear(correctForLastDayOfMonth(dd, mm), mm, yyyy);
				} else {
					throw new IllegalArgumentException(Messages.getString("DATESHIFT_DATE_INT_INT_INT.MultipleShifts")); //$NON-NLS-1$
				}
			}
		} else {
			if (months == 0 && days == 0) {
				yyyy += years;
				dd = correctForLeapDateInNonLeapYear(dd, mm, yyyy);
			} else {
				throw new IllegalArgumentException(Messages.getString("DATESHIFT_DATE_INT_INT_INT.MultipleShifts")); //$NON-NLS-1$
			}
		}

		return DbmsDateImplementation.getValueBuffer(yyyy, mm + 1, dd);
	}

	/**
	 * DATESHIFT takes a DATE argument plus three INT arguments.
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * DATESHIFT returns a DATE
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.DATE;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
