/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;
import be.erwinsmout.MyMessageFormat;

/**
 * Integer division.
 * 
 * @author Erwin
 */
public final class DIV_INT_INT implements OperatorImplementation_V0104 {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.INT, TYPENAMES.INT };

	/**
	 * DIV returns the result of dividing the first INT argument by the second.
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		final int dividend = DbmsIntImplementation.getJavaInt((ScalarValueBuffer) args.get(0));
		final int divisor = DbmsIntImplementation.getJavaInt((ScalarValueBuffer) args.get(1));
		if (dividend == Integer.MIN_VALUE && divisor == -1) {
			throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("PLUS_INT_INT.Overflow"), new String[] {})); //$NON-NLS-1$
		}
		return DbmsIntImplementation.getValueBuffer(((dividend / divisor)));
	}

	/**
	 * The operator takes two arguments, each of type INT
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The return type is INT
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.INT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
