/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;
import be.erwinsmout.MyMessageFormat;

/**
 * The implementation for the LONG division operator.
 * 
 * @author Erwin
 */
public final class DIV_LONG_LONG implements OperatorImplementation_V0104 {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.LONG, TYPENAMES.LONG };

	/**
	 * DIV returns the result of dividing the first LONG argument by the second.
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		final long dividend = DbmsLongImplementation.getJavaLong((ScalarValueBuffer) args.get(0));
		final long divisor = DbmsLongImplementation.getJavaLong((ScalarValueBuffer) args.get(1));
		if (dividend == Long.MIN_VALUE && divisor == -1) {
			throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("PLUS_INT_INT.Overflow"), new String[] {})); //$NON-NLS-1$
		}
		return DbmsLongImplementation.getValueBuffer(dividend / divisor);
	}

	/**
	 * The operator takes two arguments, each of type LONG
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The return type is LONG
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.LONG;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
