/*
 * Created on 7-jun-04
 */
package be.SIRAPRISE.typeimplementations;

import java.nio.ByteBuffer;
import java.util.*;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.DuplicateNameException;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;
import be.SIRAPRISE.util.MyReadOnlyMap;
import be.SIRAPRISE.util.MyReadOnlySet;
import be.SIRAPRISE.util.NoClosingBracketException;
import be.SIRAPRISE.util.NoOpeningBracketException;
import be.erwinsmout.MyMessageFormat;

/**
 * Type 'Bar' is provided to demonstrate the type-plugin feature, and to test the catalog constraints re. types. It uses a possrep component that needs the interval type based on FOO.
 * 
 * @author Erwin Smout
 */
public final class DbmsBarImplementation implements TypeImplementation, PossRepImplementation {
	/**
	 * 
	 */
	private final static DbmsBarImplementation instance = new DbmsBarImplementation();

	/**
	 * 
	 */
	private static final int physicalLength = 34;

	/**
	 * 
	 */
	private static final String RANGE = "RANGE"; //$NON-NLS-1$

	/**
	 * Gets instance
	 * 
	 * @return instance.
	 */
	public static DbmsBarImplementation getInstance ( ) {
		return instance;
	}

	/**
	 * The components of the default possrep (=degrees minutes seconds)
	 */
	private final Map<String, String> componentNameMap = initComponentNameMap();

	/**
	 * Map of the possreps
	 */
	private Set<PossRepImplementation> possrepImplementations = new MyReadOnlySet<PossRepImplementation>(new HashSet<PossRepImplementation>(Arrays.asList(new PossRepImplementation[] { this })));

	/**
	 * 
	 */
	private Map<String, PossRepImplementation> possrepImplementationsPerComponent = initPossrepImplementationsPerComponent();

	/**
	 * Builds the DbmsAngleImplementation object
	 */
	private DbmsBarImplementation ( ) {

	}

	/**
	 * @return
	 */
	private Map<String, String> initComponentNameMap ( ) {
		final HashMap<String, String> w = new HashMap<String, String>();
		w.put(RANGE, "FOOINTERVAL"); //$NON-NLS-1$
		return new MyReadOnlyMap<String, String>(w);
	}

	/**
	 * @return
	 */
	private Map<String, PossRepImplementation> initPossrepImplementationsPerComponent ( ) {
		HashMap<String, PossRepImplementation> w = new HashMap<String, PossRepImplementation>();
		for (PossRepImplementation possrepImplementation : possrepImplementations) {
			for (String componentName : possrepImplementation.getComponentNameMap().keySet()) {
				w.put(componentName, possrepImplementation);
			}
		}
		return new MyReadOnlyMap<String, PossRepImplementation>(w);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.TypeImplementations.PossRepImplementation#getComponentNameMap()
	 */
	public Map<String, String> getComponentNameMap ( ) {
		return componentNameMap;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#extractComponentValue(java.lang.String, be.erwinsmout.SIRA_PRISE.typeimplementations.ScalarValueBuffer)
	 */
	public ValueBuffer getComponentValue (String componentName, ScalarValueBuffer valueBuffer) {
		ByteBuffer result = ByteBuffer.allocate(34); // two angle values plus an infinity indicator
		if (componentName.equalsIgnoreCase(RANGE)) {
			result.put((ByteBuffer) valueBuffer.getByteBuffer().rewind().limit(34));
			return new ScalarValueBuffer(result);
		}
		throw new IllegalArgumentException(componentName);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.TypeImplementation#getDefaultPossrepImplementation()
	 */
	public PossRepImplementation getDefaultPossrepImplementation ( ) {
		return this;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.TypeImplementations.TypeImplementation#getDefaultSize()
	 */
	public int getDfltLogicalSize ( ) {
		return 1;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.TypeImplementations.TypeImplementation#getMaxSize()
	 */
	public int getMaxLogicalSize ( ) {
		return 1;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.TypeImplementations.TypeImplementation#getMinSize()
	 */
	public int getMinLogicalSize ( ) {
		return 1;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.TypeImplementation#getPhysicalSizeFor(int)
	 */
	public int getPhysicalSizeFor (int logicalSize) {
		return 34;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.TypeImplementation#getPossrepImplementation(java.lang.String)
	 */
	@Override
	public PossRepImplementation getPossrepImplementation (String componentName) {
		PossRepImplementation possRepImplementation = possrepImplementationsPerComponent.get(componentName);
		if (possRepImplementation == null) {
			throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("IntervalTypeImplementation.UnknownCompoenent"), new String[] { componentName, this.getClass().getName() })); //$NON-NLS-1$
		}
		return possRepImplementation;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.TypeImplementation#getPossRepImplementation()
	 */
	public Set<PossRepImplementation> getPossrepImplementations ( ) {
		return possrepImplementations;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#getName()
	 */
	public String getPossrepName ( ) {
		return "BAR"; //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#valueFromComponentValues(java.util.HashMap, int)
	 */
	public ValueBuffer valueFromComponentValues (HashMap<String, ValueBuffer> componentValueMap, int logicalSize) {
		ByteBuffer result = ByteBuffer.allocate(physicalLength);
		result.put((ByteBuffer) ((ScalarValueBuffer) componentValueMap.get(RANGE)).getByteBuffer().rewind().limit(18));
		return new ScalarValueBuffer(result);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.TypeImplementations.TypeImplementation#valueFromExternalRepresentation(java.lang.String)
	 */
	public ValueBuffer valueFromExternalRepresentation (String value) throws InvalidValueException {
		Map<String, String> componentValuesMap;
		try {
			componentValuesMap = BracketParser.createMapFromEscapedString(value, false);
		} catch (NoClosingBracketException e) {
			throw new InvalidValueException(Messages.getString("DbmsAngleImplementation.BracketSyntax"), e); //$NON-NLS-1$
		} catch (InvalidEscapedCharacterException e) {
			throw new InvalidValueException(Messages.getString("DbmsAngleImplementation.BracketSyntax"), e); //$NON-NLS-1$
		} catch (MissingEscapedCharacterException e) {
			throw new InvalidValueException(Messages.getString("DbmsAngleImplementation.BracketSyntax"), e); //$NON-NLS-1$
		} catch (NoOpeningBracketException e) {
			throw new InvalidValueException(Messages.getString("DbmsAngleImplementation.BracketSyntax"), e); //$NON-NLS-1$
		} catch (DuplicateNameException e) {
			throw new InvalidValueException(Messages.getString("DbmsAngleImplementation.BracketSyntax"), e); //$NON-NLS-1$
		}
		String horz_tx = componentValuesMap.get(RANGE);
		if (horz_tx == null) {
			throw new InvalidValueException(Messages.getString("DbmsAngleImplementation.ComponentMissing")); //$NON-NLS-1$
		}

		throw new UnsupportedOperationException("Type Bar only demoes the type plug-in features.  It does not support actually being used."); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.TypeImplementations.TypeImplementation#valueFromExternalRepresentation(java.lang.String, int)
	 */
	public ValueBuffer valueFromExternalRepresentation (String value, int maximumLogicalLengthAllowed) throws InvalidValueException {
		return valueFromExternalRepresentation(value);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#valueToEscapedExternalRepresentation(be.erwinsmout.SIRA_PRISE.typeimplementations.ValueBuffer)
	 */
	public String valueToEscapedExternalRepresentation (ValueBuffer valueBuffer) {
		return valueToExternalRepresentation(valueBuffer);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.TypeImplementations.TypeImplementation#valueToExternalRepresentation(java.nio.ByteBuffer, int, int, int)
	 */
	public String valueToExternalRepresentation (ValueBuffer valueBuffer) {
		throw new UnsupportedOperationException("Type Bar only demoes the type plug-in features.  It does not support actually being used."); //$NON-NLS-1$
		// ByteBuffer byteBuffer = ((ScalarValueBuffer) valueBuffer).getByteBuffer();
		// double horz_b = byteBuffer.getDouble();
		// short horz_inf = byteBuffer.getShort();
		// double horz_end = byteBuffer.getDouble();
		// double vert_b = byteBuffer.getDouble();
		// short vert_inf = byteBuffer.getShort();
		// double vert_end = byteBuffer.getDouble();

		//		return "RANGE(" + POSSREPCOMPONENTNAMES.BEGIN + "(" + horz_b + ")" + (IntervalTypeImplementation.isPositiveFinite(horz_inf) ? POSSREPCOMPONENTNAMES.END + "(" + horz_end + ")" : "") + ")VERT(" + POSSREPCOMPONENTNAMES.BEGIN + "(" + vert_b + ")" + (IntervalTypeImplementation.isPositiveFinite(vert_inf) ? POSSREPCOMPONENTNAMES.END + "(" + vert_end + ")" : "") + ")"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$ //$NON-NLS-12$ //$NON-NLS-13$
	}
}