/*
 * Created on 26-apr-2004
 */
package be.SIRAPRISE.typeimplementations;

import java.nio.ByteBuffer;
import java.util.*;

import be.SIRAPRISE.client.NAMES.POSSREPCOMPONENTNAMES;
import be.SIRAPRISE.client.NAMES.POSSREPNAMES;
import be.SIRAPRISE.client.NAMES.TYPENAMES;
import be.SIRAPRISE.util.MyReadOnlyMap;
import be.SIRAPRISE.util.MyReadOnlySet;
import be.erwinsmout.MyMessageFormat;

/**
 * The implementation for the SIRA_PRISE int type. The physical encoding of INT values consists of 4 bytes holding a java int.
 * 
 * @author Erwin Smout
 */
public final class DbmsIntImplementation implements TypeImplementation, PossRepImplementation {

	/**
	 * The implementation for the hexadecimal possrep of the SIRA_PRISE int type
	 * 
	 * @author Erwin Smout
	 */
	final class HEX implements PossRepImplementation {

		/**
		 * tokens that can occur in a hex representation
		 */
		static final String hextokens = "0123456789ABCDEF"; //$NON-NLS-1$

		/**
		 * The component names of this possrep
		 */
		private MyReadOnlyMap<String, String> hexComponentNameMap = initHexComponentNameMap();

		/**
		 * @return
		 */
		private MyReadOnlyMap<String, String> initHexComponentNameMap ( ) {
			HashMap<String, String> w = new HashMap<String, String>();
			w.put(POSSREPCOMPONENTNAMES.HEX, TYPENAMES.STRING);
			return new MyReadOnlyMap<String, String>(w);
		}

		/**
		 * 
		 */
		HEX ( ) {

		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.erwinsmout.SIRA_PRISE.TypeImplementations.PossRepImplementation#getComponentNameMap()
		 */
		public Map<String, String> getComponentNameMap ( ) {
			return hexComponentNameMap;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#extractComponentValue(java.lang.String, be.erwinsmout.SIRA_PRISE.typeimplementations.ScalarValueBuffer)
		 */
		public ValueBuffer getComponentValue (String componentName, ScalarValueBuffer valueBuffer) {
			try {
				return DbmsStringImplementation.getValueBuffer(valueToExternalRepresentation(valueBuffer));
			} catch (InvalidValueException e) {
				throw new RuntimeException(e);
			}
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#getName()
		 */
		public String getPossrepName ( ) {
			return POSSREPNAMES.HEX;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#valueFromComponentValues(java.util.HashMap, int)
		 */
		public ValueBuffer valueFromComponentValues (HashMap<String, ValueBuffer> componentValueMap, int logicalSize) {
			return valueFromExternalRepresentation(DbmsStringImplementation.getJavaString((ScalarValueBuffer) componentValueMap.get(POSSREPCOMPONENTNAMES.HEX)));
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.erwinsmout.DBMS.Server.PossRepImplementation#valueFromExternalRepresentation(java.lang.String)
		 */
		public ValueBuffer valueFromExternalRepresentation (String value) {
			long neg = 2 * ((long) Integer.MAX_VALUE + 1);
			long v = 0;
			int p = 0, m, mul = 1;
			String wrk = value;
			char c;
			while (wrk.length() > 0) {
				c = wrk.charAt(wrk.length() - 1);
				wrk = wrk.substring(0, wrk.length() - 1);
				p++;
				if (c == 'a' || c == 'A') {
					m = 10;
				} else {
					if (c == 'b' || c == 'B') {
						m = 11;
					} else {
						if (c == 'c' || c == 'C') {
							m = 12;
						} else {
							if (c == 'd' || c == 'D') {
								m = 13;
							} else {
								if (c == 'e' || c == 'E') {
									m = 14;
								} else {
									if (c == 'f' || c == 'F') {
										m = 15;
									} else {
										if (c == '0') {
											m = 0;
										} else {
											if (c == '1') {
												m = 1;
											} else {
												if (c == '2') {
													m = 2;
												} else {
													if (c == '3') {
														m = 3;
													} else {
														if (c == '4') {
															m = 4;
														} else {
															if (c == '5') {
																m = 5;
															} else {
																if (c == '6') {
																	m = 6;
																} else {
																	if (c == '7') {
																		m = 7;
																	} else {
																		if (c == '8') {
																			m = 8;
																		} else {
																			if (c == '9') {
																				m = 9;
																			} else {
																				throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("DbmsIntImplementation.InvalidHexToken"), new String[] { Character.toString(c), value })); //$NON-NLS-1$
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
				if (p > 8 && m != 0) {
					throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("DbmsIntImplementation.HexTooLong"), new String[] { value })); //$NON-NLS-1$
				}
				v += mul * m;
				mul *= 16;
				if (p == 8 && m > 7) {
					v -= neg;
				}
			}
			return DbmsIntImplementation.getValueBuffer((int) v);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.erwinsmout.DBMS.Server.PossRepImplementation#valueFromExternalRepresentation(java.lang.String, int)
		 */
		public ValueBuffer valueFromExternalRepresentation (String value, int maximumLogicalLengthAllowed) throws InvalidValueException {
			return valueFromExternalRepresentation(value);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#valueToEscapedExternalRepresentation(be.erwinsmout.SIRA_PRISE.typeimplementations.ValueBuffer)
		 */
		public String valueToEscapedExternalRepresentation (ValueBuffer valueBuffer) {
			return valueToExternalRepresentation(valueBuffer);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.erwinsmout.DBMS.Server.PossRepImplementation#valueToExternalRepresentation(java.nio.ByteBuffer)
		 */
		public String valueToExternalRepresentation (ValueBuffer valueBuffer) {
			ByteBuffer byteBuffer = ((ScalarValueBuffer) valueBuffer).getByteBuffer();
			int value = ((ByteBuffer) byteBuffer.rewind()).getInt(), m;
			String hex = ""; //$NON-NLS-1$
			do {
				m = value & 0x0000000f;
				value >>>= 4;
				hex = hextokens.charAt(m) + hex;
			} while (value > 0);
			return hex;
		}
	}

	/**
	 * the instance.
	 */
	private static DbmsIntImplementation instance = new DbmsIntImplementation();

	/**
	 * Gets the instance
	 * 
	 * @return the instance
	 */
	public static DbmsIntImplementation getInstance ( ) {
		return instance;
	}

	/**
	 * Gets The Integer of the value that value is the external representation of
	 * 
	 * @param value
	 *            A String representing an integer value
	 * @return The Integer of the value that value is the external representation of
	 */
	public static int getIntegerFromString (String value) {
		try {
			return Integer.parseInt(value);
		} catch (NumberFormatException e) {
			throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("DbmsIntImplementation.Value"), new String[] { value })); //$NON-NLS-1$
		}
	}

	/**
	 * Inspects a ScalarValueBuffer holding an integer and returns that integer
	 * 
	 * @param valueBuffer
	 *            The scalarvaluebuffer holding an integer value
	 * @return the contained integer
	 */
	public static int getJavaInt (ScalarValueBuffer valueBuffer) {
		return valueBuffer.getByteBuffer().getInt();
	}

	/**
	 * Returns a ScalarValueBuffer holding the given integer value
	 * 
	 * @param i
	 *            an integer
	 * @return A Bytebuffer holding the integer
	 */
	public static ScalarValueBuffer getValueBuffer (int i) {
		return new ScalarValueBuffer(ByteBuffer.allocate(4).putInt(i));
	}

	/**
	 * The components of the INT possrep implemented by the type implementation itself
	 */
	private MyReadOnlyMap<String, String> componentNameMap = initComponentNameMap();

	/**
	 * Set of all the possrep implementations for this type.
	 */
	private Set<PossRepImplementation> possrepImplementations = new MyReadOnlySet<PossRepImplementation>(new HashSet<PossRepImplementation>(Arrays.asList(new PossRepImplementation[] { new HEX(), this })));

	/**
	 * Mapping of the possrep implementations, mapped to their component names.
	 */
	private Map<String, PossRepImplementation> possrepImplementationsPerComponent = initPossrepImplementationsPerComponent();

	/**
	 * 
	 */
	private DbmsIntImplementation ( ) {

	}

	/**
	 * @return
	 */
	private MyReadOnlyMap<String, String> initComponentNameMap ( ) {
		// The default component has a "conceptual" component named STRING of type STRING
		HashMap<String, String> w = new HashMap<String, String>();
		w.put(TYPENAMES.STRING, TYPENAMES.STRING);
		return new MyReadOnlyMap<String, String>(w);
	}

	/**
	 * @return
	 */
	private MyReadOnlyMap<String, PossRepImplementation> initPossrepImplementationsPerComponent ( ) {
		HashMap<String, PossRepImplementation> w = new HashMap<String, PossRepImplementation>();
		for (PossRepImplementation possrepImplementation : possrepImplementations) {
			for (String componentName : possrepImplementation.getComponentNameMap().keySet()) {
				w.put(componentName, possrepImplementation);
			}
		}
		return new MyReadOnlyMap<String, PossRepImplementation>(w);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.TypeImplementations.PossRepImplementation#getComponentNameMap()
	 */
	public Map<String, String> getComponentNameMap ( ) {
		return componentNameMap;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#extractComponentValue(java.lang.String, be.erwinsmout.SIRA_PRISE.typeimplementations.ScalarValueBuffer)
	 */
	public ValueBuffer getComponentValue (String componentName, ScalarValueBuffer valueBuffer) {
		try {
			return DbmsStringImplementation.getValueBuffer(valueToExternalRepresentation(valueBuffer));
		} catch (InvalidValueException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * The default possrep is the INT possrep, consisting of a single component of type STRING
	 */
	public PossRepImplementation getDefaultPossrepImplementation ( ) {
		return this;
	}

	/**
	 * The default, min and max logical size is 1
	 */
	public int getDfltLogicalSize ( ) {
		return 1;
	}

	/**
	 * The default, min and max logical size is 1
	 */
	public int getMaxLogicalSize ( ) {
		return 1;
	}

	/**
	 * The default, min and max logical size is 1
	 */
	public int getMinLogicalSize ( ) {
		return 1;
	}

	/**
	 * The physical size of an encoding is always 4 bytes
	 */
	public int getPhysicalSizeFor (int logicalSize) {
		return 4;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.TypeImplementation#getPossrepImplementation(java.lang.String)
	 */
	@Override
	public PossRepImplementation getPossrepImplementation (String componentName) {
		PossRepImplementation possRepImplementation = possrepImplementationsPerComponent.get(componentName);
		if (possRepImplementation == null) {
			throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("IntervalTypeImplementation.UnknownCompoenent"), new String[] { componentName, this.getClass().getName() })); //$NON-NLS-1$
		}
		return possRepImplementation;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.TypeImplementation#getPossRepImplementation()
	 */
	public Set<PossRepImplementation> getPossrepImplementations ( ) {
		return possrepImplementations;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#getName()
	 */
	public String getPossrepName ( ) {
		return POSSREPNAMES.INT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#valueFromComponentValues(java.util.HashMap, int)
	 */
	public ValueBuffer valueFromComponentValues (HashMap<String, ValueBuffer> componentValueMap, int logicalSize) {
		return valueFromExternalRepresentation(DbmsStringImplementation.getJavaString((ScalarValueBuffer) componentValueMap.get(TYPENAMES.STRING)));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.TypeImplementations.TypeImplementation#valueFromExternalRepresentation(java.lang.String)
	 */
	public ValueBuffer valueFromExternalRepresentation (String value) {
		return getValueBuffer(getIntegerFromString(value));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.Server.TypeImplementation#fromExternal(java.lang.String)
	 */
	public ValueBuffer valueFromExternalRepresentation (String value, int maximumLogicalLengthAllowed) throws InvalidValueException {
		return valueFromExternalRepresentation(value);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#valueToEscapedExternalRepresentation(be.erwinsmout.SIRA_PRISE.typeimplementations.ValueBuffer)
	 */
	public String valueToEscapedExternalRepresentation (ValueBuffer valueBuffer) {
		return valueToExternalRepresentation(valueBuffer);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.Server.TypeImplementation#toExternal(java.nio.ByteBuffer, int, int, int)
	 */
	public String valueToExternalRepresentation (ValueBuffer valueBuffer) {
		return Integer.toString(getJavaInt((ScalarValueBuffer) valueBuffer));
	}
}