/*
 * Created on 26-apr-2004
 */
package be.SIRAPRISE.typeimplementations;

import java.nio.ByteBuffer;
import java.util.*;

import be.SIRAPRISE.client.NAMES.POSSREPCOMPONENTNAMES;
import be.SIRAPRISE.client.NAMES.POSSREPNAMES;
import be.SIRAPRISE.client.NAMES.TYPENAMES;
import be.SIRAPRISE.util.MyReadOnlyMap;
import be.SIRAPRISE.util.MyReadOnlySet;
import be.erwinsmout.MyMessageFormat;

/**
 * The implementation of the SIRA_PRISE long type. The physical encoding of values of type LONG consists of 8 bytes holding a java long value.
 * 
 * @author Erwin Smout
 */
public final class DbmsLongImplementation implements TypeImplementation, PossRepImplementation {

	/**
	 * The implementation for the hexadecimal possrep of the long type
	 * 
	 * @author Erwin Smout
	 */
	final class HEX implements PossRepImplementation {

		/**
		 * tokens that can occur in a hex representation
		 */
		static final String hextokens = "0123456789ABCDEF"; //$NON-NLS-1$

		/**
		 * The components of the possrep
		 */
		private MyReadOnlyMap<String, String> hexComponentNameMap = initHexComponentNameMap();

		/**
		 * 
		 */
		HEX ( ) {

		}

		/**
		 * @return
		 */
		private MyReadOnlyMap<String, String> initHexComponentNameMap ( ) {
			HashMap<String, String> w = new HashMap<String, String>();
			w.put(POSSREPCOMPONENTNAMES.HEX, TYPENAMES.STRING);
			return new MyReadOnlyMap<String, String>(w);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.erwinsmout.SIRA_PRISE.TypeImplementations.PossRepImplementation#getComponentNameMap()
		 */
		public Map<String, String> getComponentNameMap ( ) {
			return hexComponentNameMap;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#extractComponentValue(java.lang.String, be.erwinsmout.SIRA_PRISE.typeimplementations.ScalarValueBuffer)
		 */
		public ValueBuffer getComponentValue (String componentName, ScalarValueBuffer valueBuffer) {
			try {
				return DbmsStringImplementation.getValueBuffer(valueToExternalRepresentation(valueBuffer));
			} catch (InvalidValueException e) {
				throw new RuntimeException(e);
			}
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#getName()
		 */
		public String getPossrepName ( ) {
			return POSSREPNAMES.HEX;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#valueFromComponentValues(java.util.HashMap, int)
		 */
		public ValueBuffer valueFromComponentValues (HashMap<String, ValueBuffer> componentValueMap, int logicalSize) {
			return valueFromExternalRepresentation(DbmsStringImplementation.getJavaString((ScalarValueBuffer) componentValueMap.get(POSSREPCOMPONENTNAMES.HEX)));
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.erwinsmout.DBMS.Server.PossRepImplementation#valueFromExternalRepresentation(java.lang.String)
		 */
		public ValueBuffer valueFromExternalRepresentation (String value) {
			long v = 0;
			int p = 0, m, mul = 1;
			String wrk = value;
			char c;
			while (wrk.length() > 0) {
				c = wrk.charAt(wrk.length() - 1);
				wrk = wrk.substring(0, wrk.length() - 1);
				p++;
				if (c == 'a' || c == 'A') {
					m = 10;
				} else {
					if (c == 'b' || c == 'B') {
						m = 11;
					} else {
						if (c == 'c' || c == 'C') {
							m = 12;
						} else {
							if (c == 'd' || c == 'D') {
								m = 13;
							} else {
								if (c == 'e' || c == 'E') {
									m = 14;
								} else {
									if (c == 'f' || c == 'F') {
										m = 15;
									} else {
										if (c == '0') {
											m = 0;
										} else {
											if (c == '1') {
												m = 1;
											} else {
												if (c == '2') {
													m = 2;
												} else {
													if (c == '3') {
														m = 3;
													} else {
														if (c == '4') {
															m = 4;
														} else {
															if (c == '5') {
																m = 5;
															} else {
																if (c == '6') {
																	m = 6;
																} else {
																	if (c == '7') {
																		m = 7;
																	} else {
																		if (c == '8') {
																			m = 8;
																		} else {
																			if (c == '9') {
																				m = 9;
																			} else {
																				throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("DbmsLongImplementation.InvalidHexToken"), new String[] { Character.toString(c), value })); //$NON-NLS-1$
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
				if (p > 16 && m != 0) {
					throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("DbmsLongImplementation.HexTooLong"), new String[] { value })); //$NON-NLS-1$
				}
				if (p == 16 && m > 7) {
					// long neg = 2 * ((long)Integer.MAX_VALUE + 1);
					// v -= neg;
					v -= Long.MAX_VALUE;
					v += mul * m;
					v -= Long.MAX_VALUE;
					v -= 2;
				} else {
					v += mul * m;
				}
				mul *= 16;
			}

			return getValueBuffer(v);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.erwinsmout.DBMS.Server.PossRepImplementation#valueFromExternalRepresentation(java.lang.String, int)
		 */
		public ValueBuffer valueFromExternalRepresentation (String value, int maximumLogicalLengthAllowed) throws InvalidValueException {
			return valueFromExternalRepresentation(value);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#valueToEscapedExternalRepresentation(be.erwinsmout.SIRA_PRISE.typeimplementations.ValueBuffer)
		 */
		public String valueToEscapedExternalRepresentation (ValueBuffer valueBuffer) {
			return valueToExternalRepresentation(valueBuffer);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.erwinsmout.DBMS.Server.PossRepImplementation#valueToExternalRepresentation(java.nio.ByteBuffer)
		 */
		public String valueToExternalRepresentation (ValueBuffer valueBuffer) {
			ByteBuffer byteBuffer = ((ScalarValueBuffer) valueBuffer).getByteBuffer();
			long value = ((ByteBuffer) byteBuffer.rewind()).getLong();
			int m;
			String hex = ""; //$NON-NLS-1$
			do {
				m = (int) (value & 0x0000000f);
				value >>>= 4;
				hex = hextokens.charAt(m) + hex;
			} while (value > 0);
			return hex;
		}
	}

	/**
	 * the instance
	 */
	private static DbmsLongImplementation instance = new DbmsLongImplementation();

	/**
	 * Gets the textual representation of a Long value
	 * 
	 * @param valueBuffer
	 *            A ValueBuffer holding a Long value
	 * @return The external representation of the long value held in the given valueBuffer
	 */
	public static String getExternalRepresentation (ValueBuffer valueBuffer) {
		return Long.toString(((ScalarValueBuffer) valueBuffer).getByteBuffer().getLong());
	}

	/**
	 * Gets the instance
	 * 
	 * @return the instance
	 */
	public static DbmsLongImplementation getInstance ( ) {
		return instance;
	}

	/**
	 * @param valueBuffer
	 *            A ScalarValueBuffer containing a java long
	 * @return The java long contained in the given valueBuffer's bytebuffer
	 */
	public static long getJavaLong (ScalarValueBuffer valueBuffer) {
		return ((ByteBuffer) valueBuffer.getByteBuffer().rewind()).getLong();
	}

	/**
	 * Converts a value into a ScalarValueBuffer
	 * 
	 * @param value
	 *            the given value to be represented in a ScalarValueBuffer
	 * @return A ScalarValueBuffer holding the given long value
	 */
	public static ScalarValueBuffer getValueBuffer (long value) {
		return new ScalarValueBuffer(ByteBuffer.allocate(8).putLong(value));
	}

	/**
	 * The components of the default possrep
	 */
	private MyReadOnlyMap<String, String> componentNameMap = initComponentNameMap();

	/**
	 * Map of the possreps
	 */
	private Set<PossRepImplementation> possrepImplementations = new MyReadOnlySet<PossRepImplementation>(new HashSet<PossRepImplementation>(Arrays.asList(new PossRepImplementation[] { this, new HEX() })));

	/**
	 * 
	 */
	private Map<String, PossRepImplementation> possrepImplementationsPerComponent = initPossrepImplementationsPerComponent();

	/**
	 * 
	 */
	private DbmsLongImplementation ( ) {

	}

	/**
	 * @return
	 */
	private MyReadOnlyMap<String, String> initComponentNameMap ( ) {
		Map<String, String> w = new HashMap<String, String>();
		w.put(TYPENAMES.STRING, TYPENAMES.STRING);
		return new MyReadOnlyMap<String, String>(w);
	}

	/**
	 * @return
	 */
	private MyReadOnlyMap<String, PossRepImplementation> initPossrepImplementationsPerComponent ( ) {
		HashMap<String, PossRepImplementation> w = new HashMap<String, PossRepImplementation>();
		for (PossRepImplementation possrepImplementation : possrepImplementations) {
			for (String componentName : possrepImplementation.getComponentNameMap().keySet()) {
				w.put(componentName, possrepImplementation);
			}
		}
		return new MyReadOnlyMap<String, PossRepImplementation>(w);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.TypeImplementations.PossRepImplementation#getComponentNameMap()
	 */
	public Map<String, String> getComponentNameMap ( ) {
		return componentNameMap;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#extractComponentValue(java.lang.String, be.erwinsmout.SIRA_PRISE.typeimplementations.ScalarValueBuffer)
	 */
	public ValueBuffer getComponentValue (String componentName, ScalarValueBuffer valueBuffer) {
		try {
			return DbmsStringImplementation.getValueBuffer(valueToExternalRepresentation(valueBuffer));
		} catch (InvalidValueException e) {
			throw new RuntimeException(e);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.TypeImplementation#getDefaultPossrepImplementation()
	 */
	public PossRepImplementation getDefaultPossrepImplementation ( ) {
		return this;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.TypeImplementations.TypeImplementation#getDefaultSize()
	 */
	public int getDfltLogicalSize ( ) {
		return 18;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.TypeImplementations.TypeImplementation#getMaxSize()
	 */
	public int getMaxLogicalSize ( ) {
		return 18;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.TypeImplementations.TypeImplementation#getMinSize()
	 */
	public int getMinLogicalSize ( ) {
		return 18;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.TypeImplementation#getPhysicalSizeFor(int)
	 */
	public int getPhysicalSizeFor (int logicalSize) {
		return 8;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.TypeImplementation#getPossrepImplementation(java.lang.String)
	 */
	@Override
	public PossRepImplementation getPossrepImplementation (String componentName) {
		PossRepImplementation possRepImplementation = possrepImplementationsPerComponent.get(componentName);
		if (possRepImplementation == null) {
			throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("IntervalTypeImplementation.UnknownCompoenent"), new String[] { componentName, this.getClass().getName() })); //$NON-NLS-1$
		}
		return possRepImplementation;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.TypeImplementation#getPossRepImplementation()
	 */
	public Set<PossRepImplementation> getPossrepImplementations ( ) {
		return possrepImplementations;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#getName()
	 */
	public String getPossrepName ( ) {
		return POSSREPNAMES.LONG;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#valueFromComponentValues(java.util.HashMap, int)
	 */
	public ValueBuffer valueFromComponentValues (HashMap<String, ValueBuffer> componentValueMap, int logicalSize) {
		return valueFromExternalRepresentation(DbmsStringImplementation.getJavaString((ScalarValueBuffer) componentValueMap.get(TYPENAMES.STRING)));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.TypeImplementations.TypeImplementation#valueFromExternalRepresentation(java.lang.String)
	 */
	public ValueBuffer valueFromExternalRepresentation (String value) {
		try {
			return getValueBuffer(Long.parseLong(value));
		} catch (NumberFormatException e) {
			throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("DbmsLongImplementation.value"), new String[] { value })); //$NON-NLS-1$
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.Server.TypeImplementation#fromExternal(java.lang.String, int)
	 */
	public ValueBuffer valueFromExternalRepresentation (String value, int maximumLogicalLengthAllowed) throws InvalidValueException {
		return valueFromExternalRepresentation(value);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#valueToEscapedExternalRepresentation(be.erwinsmout.SIRA_PRISE.typeimplementations.ValueBuffer)
	 */
	public String valueToEscapedExternalRepresentation (ValueBuffer valueBuffer) {
		return valueToExternalRepresentation(valueBuffer);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.Server.TypeImplementation#toExternal(java.nio.ByteBuffer, int, int, int)
	 */
	public String valueToExternalRepresentation (ValueBuffer valueBuffer) {
		return getExternalRepresentation(valueBuffer);
	}
}