/*
 * Created on 26-apr-2004
 */
package be.SIRAPRISE.typeimplementations;

import java.util.*;

import be.SIRAPRISE.client.NAMES.POSSREPCOMPONENTNAMES;
import be.SIRAPRISE.client.NAMES.POSSREPNAMES;
import be.SIRAPRISE.client.NAMES.TYPENAMES;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.DuplicateNameException;
import be.SIRAPRISE.util.FixedLengthFormatter;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;
import be.SIRAPRISE.util.MyReadOnlyMap;
import be.SIRAPRISE.util.MyReadOnlySet;
import be.SIRAPRISE.util.NoClosingBracketException;
import be.SIRAPRISE.util.NoOpeningBracketException;
import be.erwinsmout.MyMessageFormat;

/**
 * The implementation for the Sira_Prise time-of-day type. The encoding for TIMEOFDAY values is as follows :
 * <ul>
 * <li>The value is 8 bytes long, bits labeled b63-b0</li>
 * <li>The nanoseconds are an integer value in the range [0-999999999], held in b31-b0</li>
 * <li>The seconds are an integer value in the range [0-59], held in b37-b32</li>
 * <li>The minutes are an integer value in the range [0-59], held in b43-b38</li>
 * <li>The hours are an integer value in the range [0-23], held in b49-b44</li>
 * </ul>
 * 
 * @author Erwin Smout
 */
public final class DbmsTimeofdayImplementation implements TypeImplementation, PossRepImplementation {

	/**
	 * @author Erwin Smout
	 */
	final class HMS implements PossRepImplementation {

		/**
		 * The component name map
		 */
		private Map<String, String> hmsComponentNameMap = initHMSComponentNameMap();

		/**
		 * 
		 */
		HMS ( ) {

		}

		/**
		 * @return
		 */
		private MyReadOnlyMap<String, String> initHMSComponentNameMap ( ) {
			final HashMap<String, String> w = new HashMap<String, String>();
			w.put(POSSREPCOMPONENTNAMES.HOURS, TYPENAMES.INT);
			w.put(POSSREPCOMPONENTNAMES.MINUTES, TYPENAMES.INT);
			w.put(POSSREPCOMPONENTNAMES.SECONDS, TYPENAMES.INT);
			w.put(POSSREPCOMPONENTNAMES.NANOSECONDS, TYPENAMES.INT);

			return new MyReadOnlyMap<String, String>(w);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#getComponentNameMap()
		 */
		public Map<String, String> getComponentNameMap ( ) {
			return hmsComponentNameMap;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#extractComponentValue(java.lang.String, be.erwinsmout.SIRA_PRISE.typeimplementations.ScalarValueBuffer)
		 */
		public ValueBuffer getComponentValue (String componentName, ScalarValueBuffer valueBuffer) {
			if (componentName.equalsIgnoreCase(POSSREPCOMPONENTNAMES.HOURS)) {
				return DbmsIntImplementation.getValueBuffer(getHour(valueBuffer));
			}
			if (componentName.equalsIgnoreCase(POSSREPCOMPONENTNAMES.MINUTES)) {
				return DbmsIntImplementation.getValueBuffer(getMinutes(valueBuffer));
			}
			if (componentName.equalsIgnoreCase(POSSREPCOMPONENTNAMES.SECONDS)) {
				return DbmsIntImplementation.getValueBuffer(getSeconds(valueBuffer));
			}
			if (componentName.equalsIgnoreCase(POSSREPCOMPONENTNAMES.NANOSECONDS)) {
				return DbmsIntImplementation.getValueBuffer(getNanoSeconds(valueBuffer));
			}
			throw new IllegalArgumentException(componentName);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#getPossrepName()
		 */
		public String getPossrepName ( ) {
			return POSSREPNAMES.HMS;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#valueFromComponentValues(java.util.HashMap, int)
		 */
		public ValueBuffer valueFromComponentValues (HashMap<String, ValueBuffer> componentValueMap, int logicalSize) {
			return getValueBuffer(DbmsIntImplementation.getJavaInt((ScalarValueBuffer) componentValueMap.get(POSSREPCOMPONENTNAMES.HOURS)), DbmsIntImplementation.getJavaInt((ScalarValueBuffer) componentValueMap.get(POSSREPCOMPONENTNAMES.MINUTES)), DbmsIntImplementation.getJavaInt((ScalarValueBuffer) componentValueMap.get(POSSREPCOMPONENTNAMES.SECONDS)), DbmsIntImplementation.getJavaInt((ScalarValueBuffer) componentValueMap.get(POSSREPCOMPONENTNAMES.NANOSECONDS)));
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#valueFromExternalRepresentation(java.lang.String)
		 */
		public ValueBuffer valueFromExternalRepresentation (String value) throws InvalidValueException {
			Map<String, String> m;
			try {
				m = BracketParser.createMapFromEscapedString(value, false);
			} catch (NoClosingBracketException e) {
				throw new InvalidValueException(MyMessageFormat.format(Messages.getString("DbmsTimeOfDayImplementation.HMSSyntax"), new String[] { value }), e); //$NON-NLS-1$
			} catch (InvalidEscapedCharacterException e) {
				throw new InvalidValueException(MyMessageFormat.format(Messages.getString("DbmsTimeOfDayImplementation.HMSSyntax"), new String[] { value }), e); //$NON-NLS-1$
			} catch (MissingEscapedCharacterException e) {
				throw new InvalidValueException(MyMessageFormat.format(Messages.getString("DbmsTimeOfDayImplementation.HMSSyntax"), new String[] { value }), e); //$NON-NLS-1$
			} catch (NoOpeningBracketException e) {
				throw new InvalidValueException(MyMessageFormat.format(Messages.getString("DbmsTimeOfDayImplementation.HMSSyntax"), new String[] { value }), e); //$NON-NLS-1$
			} catch (DuplicateNameException e) {
				throw new InvalidValueException(MyMessageFormat.format(Messages.getString("DbmsTimeOfDayImplementation.HMSSyntax"), new String[] { value }), e); //$NON-NLS-1$
			}
			if (!m.keySet().equals(hmsComponentNameMap.keySet())) {
				throw new InvalidValueException(MyMessageFormat.format(Messages.getString("DbmsTimeOfDayImplementation.HMSComponents"), new Object[] { m.keySet(), hmsComponentNameMap.keySet() })); //$NON-NLS-1$
			}
			return getValueBuffer(DbmsIntImplementation.getIntegerFromString(m.get(POSSREPCOMPONENTNAMES.HOURS)), DbmsIntImplementation.getIntegerFromString(m.get(POSSREPCOMPONENTNAMES.MINUTES)), DbmsIntImplementation.getIntegerFromString(m.get(POSSREPCOMPONENTNAMES.SECONDS)), DbmsIntImplementation.getIntegerFromString(m.get(POSSREPCOMPONENTNAMES.NANOSECONDS)));
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#valueFromExternalRepresentation(java.lang.String, int)
		 */
		public ValueBuffer valueFromExternalRepresentation (String value, int maximumLogicalLengthAllowed) throws InvalidValueException {
			return valueFromExternalRepresentation(value);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#valueToEscapedExternalRepresentation(be.erwinsmout.SIRA_PRISE.typeimplementations.ValueBuffer)
		 */
		public String valueToEscapedExternalRepresentation (ValueBuffer valueBuffer) {
			return valueToExternalRepresentation(valueBuffer);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#valueToExternalRepresentation(be.erwinsmout.SIRA_PRISE.typeimplementations.ValueBuffer)
		 */
		public String valueToExternalRepresentation (ValueBuffer valueBuffer) {
			long v = DbmsLongImplementation.getJavaLong((ScalarValueBuffer) valueBuffer);
			return POSSREPCOMPONENTNAMES.HOURS + "(" + getHours(v) + ")" + POSSREPCOMPONENTNAMES.MINUTES + "(" + getMinutes(v) + ")" + POSSREPCOMPONENTNAMES.SECONDS + "(" + getSeconds(v) + ")" + POSSREPCOMPONENTNAMES.NANOSECONDS + "(" + getNanoSeconds(v) + ")"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
		}
	}

	/**
	 * 
	 */
	private static final int BITCOUNT_MINUTES_SECONDS_NANOSECONDS = 44;

	/**
	 * 
	 */
	private static final int BITCOUNT_NANOSECONDS = 32;

	/**
	 * 
	 */
	private static final int BITCOUNT_SECONDS_NANOSECONDS = 38;

	/**
	 * 
	 */
	private static final long HOURS_MASK = 0x0001f00000000000L;

	/**
	 * 
	 */
	private static DbmsTimeofdayImplementation instance = new DbmsTimeofdayImplementation();

	/**
	 * 
	 */
	private static final long MINUTES_MASK = 0x00000fc000000000L;

	/**
	 * 
	 */
	private static final long NANOSECONDS_MASK = 0x000000007fffffffL;

	/**
	 * 
	 */
	private static final long SECONDS_MASK = 0x0000003f00000000L;

	/**
	 * 
	 */
	public static final int MAX_HOURS = 23;

	/**
	 * 
	 */
	public static final int MAX_MINUTES = 59;

	/**
	 * 
	 */
	public static final int MAX_NANOSECONDS = 999999999;

	/**
	 * 
	 */
	public static final int MAX_SECONDS = 59;

	/**
	 * Gets the hour
	 * 
	 * @param valueBuffer
	 *            A value Buffer holding a time-of-day value
	 * @return the hour
	 */
	static int getHour (ScalarValueBuffer valueBuffer) {
		return (int) ((DbmsLongImplementation.getJavaLong(valueBuffer) & HOURS_MASK) >> BITCOUNT_MINUTES_SECONDS_NANOSECONDS);
	}

	/**
	 * Gets the minutes
	 * 
	 * @param valueBuffer
	 *            A value Buffer holding a time-of-day value
	 * @return the minutes
	 */
	static int getMinutes (ScalarValueBuffer valueBuffer) {
		return (int) ((DbmsLongImplementation.getJavaLong(valueBuffer) & MINUTES_MASK) >> BITCOUNT_SECONDS_NANOSECONDS);
	}

	/**
	 * Gets the nanoseconds
	 * 
	 * @param valueBuffer
	 *            A value Buffer holding a time-of-day value
	 * @return the nanoseconds
	 */
	static int getNanoSeconds (ScalarValueBuffer valueBuffer) {
		return (int) ((DbmsLongImplementation.getJavaLong(valueBuffer) & NANOSECONDS_MASK));
	}

	/**
	 * Gets the seconds
	 * 
	 * @param valueBuffer
	 *            A value Buffer holding a time-of-day value
	 * @return the seconds
	 */
	static int getSeconds (ScalarValueBuffer valueBuffer) {
		return (int) ((DbmsLongImplementation.getJavaLong(valueBuffer) & SECONDS_MASK) >> BITCOUNT_NANOSECONDS);
	}

	/**
	 * Gets the hours portion of a long value holding a timeofday
	 * 
	 * @param v
	 *            The long value holding a timeofday value
	 * @return the hours portion of a long value holding a timeofday
	 */
	public static int getHours (long v) {
		return (int) ((v & HOURS_MASK) >> BITCOUNT_MINUTES_SECONDS_NANOSECONDS);
	}

	/**
	 * Gets instance
	 * 
	 * @return instance.
	 */
	public static final DbmsTimeofdayImplementation getInstance ( ) {
		return instance;
	}

	/**
	 * Gets the minutes portion of a long value holding a timeofday
	 * 
	 * @param v
	 *            The long value holding a timeofday value
	 * @return the minutes portion of a long value holding a timeofday
	 */
	public static int getMinutes (long v) {
		return (int) ((v & MINUTES_MASK) >> BITCOUNT_SECONDS_NANOSECONDS);
	}

	/**
	 * Gets the nanoseconds portion of a long value holding a timeofday
	 * 
	 * @param v
	 *            The long value holding a timeofday value
	 * @return the nanoseconds portion of a long value holding a timeofday
	 */
	public static int getNanoSeconds (long v) {
		return (int) (v & NANOSECONDS_MASK);
	}

	/**
	 * Gets the seconds portion of a long value holding a timeofday
	 * 
	 * @param v
	 *            The long value holding a timeofday value
	 * @return the seconds portion of a long value holding a timeofday
	 */
	public static int getSeconds (long v) {
		return (int) ((v & SECONDS_MASK) >> BITCOUNT_NANOSECONDS);
	}

	/**
	 * Creates a new ScalarValueBuffer holding the time-of-day value implied by the arguments
	 * 
	 * @param hours
	 *            The hours
	 * @param minutes
	 *            The minutes
	 * @param seconds
	 *            The seconds
	 * @param nanoSeconds
	 *            The nanoseconds
	 * @return A new ScalarValueBuffer holding the time-of-day value implied by the arguments
	 */
	public static ScalarValueBuffer getValueBuffer (int hours, int minutes, int seconds, int nanoSeconds) {
		if (hours < 0 || hours > MAX_HOURS || minutes < 0 || minutes > MAX_MINUTES || seconds < 0 || seconds > MAX_SECONDS || nanoSeconds < 0 || nanoSeconds > MAX_NANOSECONDS) {
			throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("DbmsTimeofdayImplementation.IllegalTimeOfDayValue"), new String[] { Integer.toString(hours), Integer.toString(minutes), Integer.toString(seconds), Integer.toString(nanoSeconds) })); //$NON-NLS-1$
		}
		return DbmsLongImplementation.getValueBuffer(nanoSeconds + ((long) seconds << BITCOUNT_NANOSECONDS) + ((long) minutes << BITCOUNT_SECONDS_NANOSECONDS) + ((long) hours << BITCOUNT_MINUTES_SECONDS_NANOSECONDS));
	}

	/**
	 * The map of component/type names of the default implementation
	 */
	private Map<String, String> componentNameMap = initComponentNameMap();

	/**
	 * Map of the possreps
	 */
	private Set<PossRepImplementation> possrepImplementations = new MyReadOnlySet<PossRepImplementation>(new HashSet<PossRepImplementation>(Arrays.asList(new PossRepImplementation[] { this, new HMS() })));

	/**
	 * 
	 */
	private Map<String, PossRepImplementation> possrepImplementationsPerComponent = initPossrepImplementationsPerComponent();

	/**
	 * 
	 */
	private DbmsTimeofdayImplementation ( ) {

	}

	/**
	 * @return
	 */
	private MyReadOnlyMap<String, String> initComponentNameMap ( ) {
		final HashMap<String, String> w = new HashMap<String, String>();
		// "conceptual" component : ISO(STRING)
		w.put(POSSREPCOMPONENTNAMES.ISOWITHNANOSECONDS, TYPENAMES.STRING);
		return new MyReadOnlyMap<String, String>(w);
	}

	/**
	 * @return
	 */
	private MyReadOnlyMap<String, PossRepImplementation> initPossrepImplementationsPerComponent ( ) {
		final HashMap<String, PossRepImplementation> w = new HashMap<String, PossRepImplementation>();
		for (PossRepImplementation possrepImplementation : possrepImplementations) {
			for (String componentName : possrepImplementation.getComponentNameMap().keySet()) {
				w.put(componentName, possrepImplementation);
			}
		}
		return new MyReadOnlyMap<String, PossRepImplementation>(w);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.TypeImplementations.PossRepImplementation#getComponentNameMap()
	 */
	public Map<String, String> getComponentNameMap ( ) {
		return componentNameMap;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#extractComponentValue(java.lang.String, be.erwinsmout.SIRA_PRISE.typeimplementations.ScalarValueBuffer)
	 */
	public ValueBuffer getComponentValue (String componentName, ScalarValueBuffer valueBuffer) {
		try {
			return DbmsStringImplementation.getValueBuffer(valueToExternalRepresentation(valueBuffer));
		} catch (InvalidValueException e) {
			throw new RuntimeException(e);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.TypeImplementation#getDefaultPossrepImplementation()
	 */
	public PossRepImplementation getDefaultPossrepImplementation ( ) {
		return this;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.TypeImplementations.TypeImplementation#getDefaultSize()
	 */
	public int getDfltLogicalSize ( ) {
		return 1;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.TypeImplementations.TypeImplementation#getMaxSize()
	 */
	public int getMaxLogicalSize ( ) {
		return 1;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.TypeImplementations.TypeImplementation#getMinSize()
	 */
	public int getMinLogicalSize ( ) {
		return 1;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.TypeImplementation#getPhysicalSizeFor(int)
	 */
	public int getPhysicalSizeFor (int logicalSize) {
		return 8;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.TypeImplementation#getPossrepImplementation(java.lang.String)
	 */
	@Override
	public PossRepImplementation getPossrepImplementation (String componentName) {
		PossRepImplementation possRepImplementation = possrepImplementationsPerComponent.get(componentName);
		if (possRepImplementation == null) {
			throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("IntervalTypeImplementation.UnknownCompoenent"), new String[] { componentName, this.getClass().getName() })); //$NON-NLS-1$
		}
		return possRepImplementation;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.TypeImplementation#getPossRepImplementation()
	 */
	public Set<PossRepImplementation> getPossrepImplementations ( ) {
		return possrepImplementations;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#getName()
	 */
	public String getPossrepName ( ) {
		return POSSREPNAMES.ISOWITHNANOSECONDS;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#valueFromComponentValues(java.util.HashMap, int)
	 */
	public ValueBuffer valueFromComponentValues (HashMap<String, ValueBuffer> componentValueMap, int logicalSize) {
		return valueFromExternalRepresentation(DbmsStringImplementation.getJavaString((ScalarValueBuffer) componentValueMap.get(POSSREPCOMPONENTNAMES.ISOWITHNANOSECONDS)));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.TypeImplementations.TypeImplementation#valueFromExternalRepresentation(java.lang.String)
	 */
	public ValueBuffer valueFromExternalRepresentation (String value) {
		if (value.length() < 8 || value.charAt(2) != ':' || value.charAt(5) != ':') {
			throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("DbmsTimeOfDayImplementation.value"), new String[] { value })); //$NON-NLS-1$
		}
		int hours, minutes, seconds;
		try {
			hours = Integer.parseInt(value.substring(0, 2));
			minutes = Integer.parseInt(value.substring(3, 5));
			seconds = Integer.parseInt(value.substring(6, 8));
		} catch (NumberFormatException e) {
			throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("DbmsTimeOfDayImplementation.value"), new String[] { value })); //$NON-NLS-1$
		}

		int nanoSeconds = 0;
		if (value.length() > 8) {
			if (value.charAt(8) != '.' || value.length() < 10) {
				throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("DbmsTimeOfDayImplementation.value"), new String[] { value })); //$NON-NLS-1$
			}
			try {
				StringBuffer nanoSecondsText = new StringBuffer(value.substring(9));
				FixedLengthFormatter.appendZeroes(9, nanoSecondsText);
				nanoSeconds = Integer.parseInt(nanoSecondsText.toString());
			} catch (NumberFormatException e) {
				throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("DbmsTimeOfDayImplementation.value"), new String[] { value })); //$NON-NLS-1$
			}
		}
		return getValueBuffer(hours, minutes, seconds, nanoSeconds);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.Server.TypeImplementation#fromExternal(java.lang.String, int)
	 */
	public ValueBuffer valueFromExternalRepresentation (String value, int maximumLogicalLengthAllowed) throws InvalidValueException {
		return valueFromExternalRepresentation(value);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.PossRepImplementation#valueToEscapedExternalRepresentation(be.erwinsmout.SIRA_PRISE.typeimplementations.ValueBuffer)
	 */
	public String valueToEscapedExternalRepresentation (ValueBuffer valueBuffer) {
		return valueToExternalRepresentation(valueBuffer);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.Server.TypeImplementation#toExternal(java.nio.ByteBuffer, int, int, int)
	 */
	public String valueToExternalRepresentation (ValueBuffer valueBuffer) {
		long v = DbmsLongImplementation.getJavaLong((ScalarValueBuffer) valueBuffer);
		long nanoSeconds = getNanoSeconds(v);
		return FixedLengthFormatter.prependZeroes(2, Long.toString(getHours(v))) + ':' + FixedLengthFormatter.prependZeroes(2, Long.toString(getMinutes(v))) + ':' + FixedLengthFormatter.prependZeroes(2, Long.toString(getSeconds(v))) + (nanoSeconds > 0 ? ('.' + FixedLengthFormatter.prependZeroes(9, Long.toString(nanoSeconds))) : ""); //$NON-NLS-1$
	}
}
