/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The ENDSWITH operator returns a truth-value indicating whether the first argument's ending sequence of tokens is identical to the second argument's complete sequence of tokens.
 * 
 * @author Erwin
 */
public final class ENDSWITH_NAME_NAME implements OperatorImplementation_V0104 {

	/**
	 * The argument type names
	 */
	private static final String[] argumentTypeNames = new String[] { TYPENAMES.NAME, TYPENAMES.NAME };

	/**
	 * ENDSWITH operator returns a truth-value indicating whether the first argument's ending sequence of tokens is identical to the second argument's complete sequence of tokens.
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return DbmsNameImplementation.getJavaString(((ScalarValueBuffer) args.get(0))).endsWith(DbmsNameImplementation.getJavaString(((ScalarValueBuffer) args.get(1)))) ? DbmsBooleanImplementation.trueValue : DbmsBooleanImplementation.falseValue;
	}

	/**
	 * ENDSWITH takes two arguments, both of type NAME
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypeNames;
	}

	/**
	 * ENDSWITH returns a BOOLEAN
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.BOOLEAN;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
