/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.nio.ByteBuffer;
import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The ENDSWITH operator returns a truth value indicating whether or not the first argument's ending sequence of tokens is identical to the second argument's complete token sequence.
 * 
 * @author Erwin
 */
public final class ENDSWITH_STRING_STRING implements OperatorImplementation_V0104 {

	/**
	 * The argument type names
	 */
	private static final String[] argumentTypeNames = new String[] { TYPENAMES.STRING, TYPENAMES.STRING };

	/**
	 * ENDSWITH returns a truth value indicating whether or not the first argument's ending sequence of tokens is identical to the second argument's complete token sequence.
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return DbmsStringImplementation.getJavaString(((ScalarValueBuffer) args.get(0))).endsWith(DbmsStringImplementation.getJavaString(((ScalarValueBuffer) args.get(1)))) ? DbmsBooleanImplementation.trueValue : new ScalarValueBuffer(ByteBuffer.allocate(4).putInt(DbmsBooleanImplementation._FALSE));
	}

	/**
	 * ENDSWITH takes two arguments, both of type STRING
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypeNames;
	}

	/**
	 * ENDSWITH returns a BOOLEAN
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.BOOLEAN;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
