/*
 * Created on 10-mei-2005
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * Boolean equality differs from all other scalar equality operators in that it also happens to be associative. For all other types, the question of associativity does not pose itself because the return type boolean is not the same as the arguments For boolean, the return type happens to be the same, and furthermore we are unfortunate enough for the operator to be damn associative, which brings us in need of another interface to be implemented (b1 = b2) = b3 === b1 = (b2 = b3) (b1 & b2 | ^b1 & ^b2) = b3 === (b3 & b2 | ^b3 & ^b2) = b1 (b1 & b2 | ^b1 & ^b2) & b3 | ^(b1 & b2 | ^b1 & ^b2) & ^b3 === (b3 & b2 | ^b3 & ^b2) = b1 (b1 & b2 &
 * b3 | ^b1 & ^b2 & b3) | (^(b1 & b2) & ^(^b1 & ^b2)) & ^b3 === (b3 & b2 | ^b3 & ^b2) = b1 (b1 & b2 & b3 | ^b1 & ^b2 & b3) | ((^b1 | ^b2) & (b1 | b2)) & ^b3 === (b3 & b2 | ^b3 & ^b2) = b1 (b1 & b2 & b3 | ^b1 & ^b2 & b3) | ((^b1 & b2) | (b1 & ^b2)) & ^b3 === (b3 & b2 | ^b3 & ^b2) = b1 (b1 & b2 & b3 | ^b1 & ^b2 & b3) | ((^b1 & b2) & ^b3 | (b1 & ^b2) & ^b3) === (b3 & b2 | ^b3 & ^b2) = b1 (b1 & b2 & b3 | ^b1 & ^b2 & b3) | ^b1 & b2 & ^b3 | b1 & ^b2 & ^b3 === (b3 & b2 | ^b3 & ^b2) = b1 ...
 * 
 * @author Erwin Smout
 */
public final class EQ_BOOLEAN_BOOLEAN implements AggregationOperatorImplementation, BinaryBooleanOperatorImplementation {

	/**
	 * Comment for <code>argumentTypes</code>
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.BOOLEAN, TYPENAMES.BOOLEAN };

	/**
	 * The instance
	 */
	private static final EQ_BOOLEAN_BOOLEAN instance = new EQ_BOOLEAN_BOOLEAN();

	/**
	 * @return the instance of the implementation
	 */
	public static EQ_BOOLEAN_BOOLEAN getInstance ( ) {
		return instance;
	}

	/**
	 *
	 */
	private EQ_BOOLEAN_BOOLEAN ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.Server.OperatorImplementation#executeOperator(java.util.LinkedList)
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return (DbmsBooleanImplementation.getJavaBoolean(((ScalarValueBuffer) args.get(0))) == DbmsBooleanImplementation.getJavaBoolean(((ScalarValueBuffer) args.get(1)))) ? DbmsBooleanImplementation.trueValue : DbmsBooleanImplementation.falseValue;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.OperatorImplementation#getArgumentTypes()
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.AssociativeOperatorImplementation#getIdentityElement()
	 */
	public ScalarValueBuffer getIdentityElement ( ) {
		return DbmsBooleanImplementation.trueValue;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.server.BinaryBooleanOperatorImplementation#getNegated(java.util.LinkedList)
	 */
	public String getNegated (String operand1, String operand2) {
		return "XOR(" + operand1 + "," + operand2 + ")"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.Server.OperatorImplementation#getReturnType()
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.BOOLEAN;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
