/*
 * Created on 15-jun-04
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The equality operator implementation for the nonscalar RELATION type
 * 
 * @author Erwin Smout
 */
public final class EQ_RELATION_RELATION implements OperatorImplementation_V0104 {

	/**
	 * The argument types of the operator
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.RELATION, TYPENAMES.RELATION };

	/**
	 * The instance
	 */
	private static final OperatorImplementation_V0104 instance = new EQ_RELATION_RELATION();

	/**
	 * Gets the instance
	 * 
	 * @return the instance
	 */
	public static OperatorImplementation_V0104 getInstance ( ) {
		return instance;
	}

	/**
     * 
     */
	private EQ_RELATION_RELATION ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.TypeImplementations.OperatorImplementation#executeOperator()
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		final ValueBuffer arg0 = args.get(0);
		final ValueBuffer arg1 = args.get(1);
		if (((RelationBuffer) arg0).getRelation().equals(((RelationBuffer) arg1).getRelation())) {
			return DbmsBooleanImplementation.trueValue;
		} else {
			return DbmsBooleanImplementation.falseValue;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.OperatorImplementation#getArgumentTypes()
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.TypeImplementations.OperatorImplementation#getReturnType()
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.BOOLEAN;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
