/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * EXP takes two FLOAT values, a and b, and returns a^b
 * 
 * @author Erwin
 */
public final class EXP_FLOAT_FLOAT implements OperatorImplementation_V0104 {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.FLOAT, TYPENAMES.FLOAT };

	/**
	 * EXP returns the value of a^b
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		final double base = DbmsFloatImplementation.getJavaDouble(args.get(0));
		final double exponent = DbmsFloatImplementation.getJavaDouble(args.get(1));
		if (base == 0.0 && exponent == 0.0) {
			throw new IllegalArgumentException(Messages.getString("EXP_FLOAT_FLOAT.Undefined")); //$NON-NLS-1$
		}
		return DbmsFloatImplementation.getValueBuffer(Math.pow(base, exponent));
	}

	/**
	 * The operator takes two arguments, both of type FLOAT
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The return type is FLOAT
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.FLOAT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
