/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The FIRSTDATE operator returns the lowest supported DATE value
 * 
 * @author Erwin
 */
public final class FIRSTDATE implements OperatorImplementation_V0104 {

	/**
	 * The argument types
	 */
	private static final String[] argumentTypeNames = new String[] {};

	/**
	 * 
	 */
	private ValueBuffer minDate;

	/**
	 * FIRSTDATE returns the lowest supported DATE value
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return minDate == null ? (minDate = DbmsDateImplementation.getValueBuffer(1, 1, 1)) : minDate;
	}

	/**
	 * The operator takes no arguments
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypeNames;
	}

	/**
	 * The return type is DATE
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.DATE;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
