/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The FIRSTINT operator returns the lowest supported INT value
 * 
 * @author Erwin
 */
public final class FIRSTINT implements OperatorImplementation_V0104 {

	/**
	 * The argument types
	 */
	private static final String[] argumentTypeNames = new String[] {};

	/**
	 * 
	 */
	private ScalarValueBuffer minInt;

	/**
	 * FIRSTINT returns the lowest supported INT value
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return minInt == null ? (minInt = DbmsIntImplementation.getValueBuffer(Integer.MIN_VALUE)) : minInt;
	}

	/**
	 * The operator takes no arguments
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypeNames;
	}

	/**
	 * The return type is INT
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.INT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
